WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool FND_DESCRIPTIONS.log


prompt
prompt Creating table FND_DESCRIPTIONS
prompt ===========================
prompt

whenever sqlerror continue
drop table FND_DESCRIPTIONS;
whenever sqlerror exit failure rollback

create table FND_DESCRIPTIONS
(
  DESCRIPTION_ID   NUMBER not null,
  LANGUAGE         VARCHAR2(4) not null,
  REF_TABLE        VARCHAR2(100) not null,
  REF_FIELD        VARCHAR2(100) not null,
  DESCRIPTION_TEXT VARCHAR2(1000),
  FUNCTION_NAME    VARCHAR2(20),
  CREATED_BY       NUMBER not null,
  CREATION_DATE    DATE not null,
  LAST_UPDATED_BY  NUMBER not null,
  LAST_UPDATE_DATE DATE not null,
  constraint FND_DESCRIPTIONS_PK primary key (DESCRIPTION_ID,LANGUAGE)
);

-- Create/Recreate indexes 
create index FND_DESCRIPTIONS_N1 on FND_DESCRIPTIONS (LANGUAGE,REF_TABLE,REF_FIELD);
create index FND_DESCRIPTIONS_N2 on FND_DESCRIPTIONS (REF_TABLE,REF_FIELD,DESCRIPTION_TEXT);


spool off

exit


