WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool FND_LANGUAGE_CODE.log

prompt
prompt Creating table FND_LANGUAGE_CODE
prompt ================================
prompt
whenever sqlerror continue
drop table FND_LANGUAGE_CODE;
whenever sqlerror exit failure rollback

create table FND_LANGUAGE_CODE
(
  LANGUAGE_CODE    VARCHAR2(4) not null,
  INSTALLED_FLAG   VARCHAR2(1),
  LOCALE_CODE	   VARCHAR2(10),
  DESCRIPTION_ID   NUMBER,
  CREATED_BY       NUMBER not null,
  CREATION_DATE    DATE not null,
  LAST_UPDATED_BY  NUMBER not null,
  LAST_UPDATE_DATE DATE not null
);

alter table FND_LANGUAGE_CODE
  add constraint FND_LANGUAGE_CODE_PK primary key (LANGUAGE_CODE);
  
create unique index FND_LANGUAGE_CODE_U1 on FND_LANGUAGE_CODE (DESCRIPTION_ID);


spool off

exit
