WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool FND_OPERATION_UNITS.log

prompt
prompt Creating table FND_OPERATION_UNITS
prompt ============================
prompt
whenever sqlerror continue
drop table FND_OPERATION_UNITS;
whenever sqlerror exit failure rollback

-- Create table
create table FND_OPERATION_UNITS
(
  OPERATION_UNIT_ID      NUMBER not null,
  COMPANY_ID             NUMBER not null,
  OPERATION_UNIT_CODE    VARCHAR2(30) not null,
  DESCRIPTION_ID         NUMBER not null,
  CHIEF_POSITION_ID	 NUMBER,
  SUMMARY_FLAG           VARCHAR2(1) not null,
  ENABLED_FLAG           VARCHAR2(1) not null,
  CREATION_DATE          DATE not null,
  CREATED_BY             NUMBER not null,
  LAST_UPDATE_DATE       DATE not null,
  LAST_UPDATED_BY        NUMBER not null
);
alter table FND_OPERATION_UNITS
  add constraint FND_OPERATION_UNITS_PK primary key (OPERATION_UNIT_ID);
create unique index FND_OPERATION_UNITS_U1 on FND_OPERATION_UNITS (COMPANY_ID,OPERATION_UNIT_CODE);

spool off

exit
