WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool FND_REGION_CODE.log

prompt
prompt Creating table FND_REGION_CODE
prompt ==============================
prompt
whenever sqlerror continue
drop table FND_REGION_CODE;
whenever sqlerror exit failure rollback

create table FND_REGION_CODE
(
  COUNTRY_CODE     VARCHAR2(4) not null,
  REGION_CODE      VARCHAR2(30) not null,
  DESCRIPTION_ID   NUMBER,
  CREATED_BY       NUMBER not null,
  CREATION_DATE    DATE not null,
  LAST_UPDATED_BY  NUMBER not null,
  LAST_UPDATE_DATE DATE not null
);

alter table FND_REGION_CODE
  add constraint FND_REGION_CODE_PK primary key (COUNTRY_CODE,REGION_CODE);
  
create unique index FND_REGION_CODE_U1 on FND_REGION_CODE (DESCRIPTION_ID);

spool off

exit
