WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;


spool GLD_ACCOUNT_SETS.log

prompt
prompt Creating table GLD_ACCOUNT_SETS
prompt ===============================
prompt
whenever sqlerror continue
drop table GLD_ACCOUNT_SETS;
whenever sqlerror exit failure rollback

create table GLD_ACCOUNT_SETS
(
  ACCOUNT_SET_ID      NUMBER not null,
  ACCOUNT_SET_CODE    VARCHAR2(30) not null,
  ACCOUNT_SET_NAME_ID NUMBER,
  COA_STRUCTURE_ID    NUMBER not null,
  CREATION_DATE       DATE not null,
  CREATED_BY          NUMBER not null,
  LAST_UPDATE_DATE    DATE not null,
  LAST_UPDATED_BY     NUMBER not null
);
  
-- Create/Recreate primary, unique and foreign key constraints 
alter table GLD_ACCOUNT_SETS
  add constraint GLD_ACCOUNT_SETS_PK primary key (ACCOUNT_SET_ID);
  
CREATE UNIQUE INDEX GLD_ACCOUNT_SETS_U1 ON GLD_ACCOUNT_SETS (ACCOUNT_SET_CODE);
CREATE UNIQUE INDEX GLD_ACCOUNT_SETS_U2 ON GLD_ACCOUNT_SETS (ACCOUNT_SET_NAME_ID);


spool off


exit

