WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool GLD_CURRENCY.log

prompt
prompt Creating table GLD_CURRENCY
prompt ===========================
prompt
whenever sqlerror continue
drop table GLD_CURRENCY;
whenever sqlerror exit failure rollback

-- Create table
create table GLD_CURRENCY
(
  CURRENCY_CODE         VARCHAR2(10) not null,
  ENABLED_FLAG          VARCHAR2(1) not null,
  CURRENCY_NAME_ID      NUMBER,
  COUNTRY_CODE          VARCHAR2(30) not null,
  PRECISION             NUMBER not null,
  TRANSACTION_PRECISION NUMBER not null,
  CURRENCY_SYMBOL       VARCHAR2(10),
  CREATION_DATE         DATE not null,
  CREATED_BY            NUMBER not null,
  LAST_UPDATE_DATE      DATE not null,
  LAST_UPDATED_BY       NUMBER not null
);
-- Create/Recreate primary, unique and foreign key constraints 
alter table GLD_CURRENCY
  add constraint GLD_CURRENCY_PK primary key (CURRENCY_CODE);
-- Create/Recreate indexes 
create index GLD_CURRENCY_N1 on GLD_CURRENCY (COUNTRY_CODE);


spool off


exit
