WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;


spool GLD_PERIOD_SETS.log


prompt
prompt Creating table GLD_PERIOD_SETS
prompt ==============================
prompt
whenever sqlerror continue
drop table GLD_PERIOD_SETS;
whenever sqlerror exit failure rollback

-- Create table
create table GLD_PERIOD_SETS
(
  PERIOD_SET_CODE        VARCHAR2(30) not null,
  PERIOD_SET_NAME_ID     NUMBER not null,
  TOTAL_PERIOD_NUM       NUMBER not null,
  PERIOD_ADDITIONAL_FLAG VARCHAR2(1) not null,
  CREATION_DATE          DATE not null,
  CREATED_BY             NUMBER not null,
  LAST_UPDATE_DATE       DATE not null,
  LAST_UPDATED_BY        NUMBER not null
);
-- Create/Recreate primary, unique and foreign key constraints 
alter table GLD_PERIOD_SETS
  add constraint GLD_PERIOD_SETS_PK primary key (PERIOD_SET_CODE);
-- Create/Recreate indexes 
create unique index GLD_PERIOD_SETS_U1 on GLD_PERIOD_SETS (PERIOD_SET_NAME_ID);


spool off


exit
