WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;


spool GLD_PERIODS.log

prompt
prompt Creating table GLD_PERIODS
prompt ==========================
prompt
whenever sqlerror continue
drop table GLD_PERIODS;
whenever sqlerror exit failure rollback

-- Create table
create table GLD_PERIODS
(
  PERIOD_SET_CODE     VARCHAR2(30) not null,
  PERIOD_YEAR         NUMBER not null,
  PERIOD_NUM          NUMBER not null,
  PERIOD_NAME         VARCHAR2(30) not null,
  ADJUSTMENT_FLAG     VARCHAR2(1) not null,
  INTERNAL_PERIOD_NUM NUMBER not null,
  START_DATE          DATE not null,
  END_DATE            DATE not null,
  QUARTER_NUM         NUMBER not null,
  CREATION_DATE       DATE not null,
  CREATED_BY          NUMBER not null,
  LAST_UPDATE_DATE    DATE not null,
  LAST_UPDATED_BY     NUMBER not null
);
-- Create/Recreate primary, unique and foreign key constraints 
alter table GLD_PERIODS
  add constraint GLD_PERIODS_PK primary key (PERIOD_SET_CODE, INTERNAL_PERIOD_NUM);
-- Create/Recreate indexes 
create unique index GLD_PERIODS_U1 on GLD_PERIODS (PERIOD_SET_CODE, PERIOD_NAME);


spool off


exit
