WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;


spool GLD_SET_OF_BOOKS.log

prompt
prompt Creating table GLD_SET_OF_BOOKS
prompt ===============================
prompt
whenever sqlerror continue
drop table GLD_SET_OF_BOOKS;
whenever sqlerror exit failure rollback

create table GLD_SET_OF_BOOKS
(
  SET_OF_BOOKS_ID          NUMBER not null,
  SET_OF_BOOKS_NAME_ID     NUMBER,
  SET_OF_BOOKS_CODE        VARCHAR2(30) not null,
  PERIOD_SET_CODE          VARCHAR2(30) not null,
  FUNCTIONAL_CURRENCY_CODE VARCHAR2(10) not null,
  ACCOUNT_SET_ID           NUMBER not null,
  ENABLED_FLAG             VARCHAR2(1) default 'Y',
  CREATION_DATE            DATE not null,
  CREATED_BY               NUMBER not null,
  LAST_UPDATE_DATE         DATE not null,
  LAST_UPDATED_BY          NUMBER not null
);


-- Create/Recreate primary, unique and foreign key constraints 
alter table GLD_SET_OF_BOOKS
  add constraint GLD_SET_OF_BOOKS_PK primary key (SET_OF_BOOKS_ID);
  
create unique index GLD_SET_OF_BOOKS_U1 on GLD_SET_OF_BOOKS (SET_OF_BOOKS_CODE);
create unique index GLD_SET_OF_BOOKS_U2 on GLD_SET_OF_BOOKS (SET_OF_BOOKS_NAME_ID);

spool off

exit