WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_CODE_VALUES.log

prompt
prompt Creating table SYS_CODE_VALUES
prompt ==============================
prompt
whenever sqlerror continue
drop table SYS_CODE_VALUES;
whenever sqlerror exit failure rollback

create table SYS_CODE_VALUES
(
  CODE_VALUE_ID      NUMBER not null,
  CODE_ID            NUMBER not null,
  CODE_VALUE         VARCHAR2(30) not null,
  CODE_VALUE_NAME_ID NUMBER,
  ENABLED_FLAG       VARCHAR2(1) not null,
  CREATION_DATE      DATE not null,
  CREATED_BY         NUMBER not null,
  LAST_UPDATE_DATE   DATE not null,
  LAST_UPDATED_BY    NUMBER not null
);
alter table SYS_CODE_VALUES
  add constraint SYS_CODE_VALUES_PK primary key (CODE_VALUE_ID);
  
create unique index SYS_CODE_VALUES_U1 on SYS_CODE_VALUES (CODE_ID,CODE_VALUE);


spool off

exit
