WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_CONFIG_CUSTOMIZATION.log

prompt
prompt Creating table SYS_CONFIG_CUSTOMIZATION
prompt ====================================
prompt
whenever sqlerror continue
drop table SYS_CONFIG_CUSTOMIZATION; 
whenever sqlerror exit failure rollback

-- Create table
create table SYS_CONFIG_CUSTOMIZATION
(
  RECORD_ID        NUMBER not null,
  HEAD_ID          NUMBER,
  ENABLE_FLAG      VARCHAR2(1) default 'Y',
  SOURCE_FILE      VARCHAR2(1000) not null,
  SOURCE_VERSION   VARCHAR2(30),
  DIMENSION_TYPE   VARCHAR2(200) not null,
  DIMENSION_VALUE  VARCHAR2(500) not null,
  ID_VALUE         VARCHAR2(200) not null,
  MOD_TYPE         VARCHAR2(50) not null,
  ARRAY_NAME       VARCHAR2(100),
  INDEX_FIELD      VARCHAR2(100),
  INDEX_VALUE      VARCHAR2(500),
  XPATH            VARCHAR2(2000),
  POSITION         VARCHAR2(50),
  CONFIG_CONTENT   VARCHAR2(4000),
  ATTRIB_KEY       VARCHAR2(100),
  ATTRIB_VALUE     VARCHAR2(2000),
  COMMENTS         VARCHAR2(2000),
  CREATED_BY       NUMBER not null,
  CREATION_DATE    DATE not null,
  LAST_UPDATED_BY  NUMBER not null,
  LAST_UPDATE_DATE DATE not null,
  FIELDS_ORDER     VARCHAR2(2000)
);
-- Add comments to the columns 
comment on column SYS_CONFIG_CUSTOMIZATION.HEAD_ID
  is 'sys_config_customization_head';
comment on column SYS_CONFIG_CUSTOMIZATION.ENABLE_FLAG
  is 'ֻд˱־=Yļ¼Ч';
comment on column SYS_CONFIG_CUSTOMIZATION.SOURCE_FILE
  is 'Դļ';
comment on column SYS_CONFIG_CUSTOMIZATION.SOURCE_VERSION
  is 'Դļ汾ȡԴļڵversion';
comment on column SYS_CONFIG_CUSTOMIZATION.DIMENSION_TYPE
  is 'άʹ';
comment on column SYS_CONFIG_CUSTOMIZATION.DIMENSION_VALUE
  is 'άֵ';
comment on column SYS_CONFIG_CUSTOMIZATION.ID_VALUE
  is 'ԪصidֵǶԶڵиԻidֵsource_fileͬ';
comment on column SYS_CONFIG_CUSTOMIZATION.MOD_TYPE
  is 'ķʽset_attrib;; replace: config_contentԭڵ; insert: config_contentݲ뵽positionָλ; delete: ɾ˽ڵ; re_order: ӽڵ; re_locate: ¶λ˽ڵ; cdata_replace: config_contentԭcdataֵ; cdata_append:config_contentеݲ뵽ԭcdataֵλposition ';
comment on column SYS_CONFIG_CUSTOMIZATION.ARRAY_NAME
  is 'Ԫأ';
comment on column SYS_CONFIG_CUSTOMIZATION.INDEX_FIELD
  is 'ԪأÿԪص';
comment on column SYS_CONFIG_CUSTOMIZATION.INDEX_VALUE
  is 'ԪأÿԪصֵ';
comment on column SYS_CONFIG_CUSTOMIZATION.XPATH
  is 'xpath·չã';
comment on column SYS_CONFIG_CUSTOMIZATION.POSITION
  is 'before: ԭڵ֮ǰ after: ԭڵ֮ first_child: Ϊһӽڵ last_child: Ϊһӽڵ';
comment on column SYS_CONFIG_CUSTOMIZATION.CONFIG_CONTENT
  is '½ڵxmlݣcdataֵ';
comment on column SYS_CONFIG_CUSTOMIZATION.ATTRIB_KEY
  is 'set_attribҪõ';
comment on column SYS_CONFIG_CUSTOMIZATION.ATTRIB_VALUE
  is 'set_attribҪõֵ';
comment on column SYS_CONFIG_CUSTOMIZATION.COMMENTS
  is '˸Իõ˵';
comment on column SYS_CONFIG_CUSTOMIZATION.FIELDS_ORDER
  is '';
-- Create/Recreate primary, unique and foreign key constraints 
alter table SYS_CONFIG_CUSTOMIZATION
  add primary key (RECORD_ID)
  using index ;
-- Create/Recreate indexes 
create index SYS_CONFIG_CUSTOMIZATION_N1 on SYS_CONFIG_CUSTOMIZATION (HEAD_ID);
create index SYS_CONFIG_CUSTOMIZATION_N2 on SYS_CONFIG_CUSTOMIZATION (SOURCE_FILE, DIMENSION_TYPE, DIMENSION_VALUE);
spool off
exit
