WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_CONFIG_DIMENSION.log

prompt
prompt Creating table SYS_CONFIG_DIMENSION
prompt ====================================
prompt
whenever sqlerror continue
drop table SYS_CONFIG_DIMENSION; 
whenever sqlerror exit failure rollback

-- Create table
create table SYS_CONFIG_DIMENSION
(
  DIMENSION_CODE      VARCHAR2(100) not null,
  DIMENSION_NAME_ID   NUMBER not null,
  ENABLED_FLAG        VARCHAR2(1) default 'Y',
  LOOKUP_BM           VARCHAR2(500),
  LOOKUP_SCREEN       VARCHAR2(500),
  DESC_LOOKUP_SQL     VARCHAR2(1000),
  DATA_QUERY_SQL      VARCHAR2(1000),
  ORDER_NUM           NUMBER,
  DESCRIPTIONS        VARCHAR2(2000),
  BUILTIN_FLAG        VARCHAR2(1),
  CREATED_BY          NUMBER not null,
  CREATION_DATE       DATE default sysdate not null,
  LAST_UPDATED_BY     NUMBER not null,
  LAST_UPDATE_DATE    DATE default sysdate not null,
  DIMENSION_INIT_PROC VARCHAR2(1000),
  DIMENSION_TAG       VARCHAR2(100)
);
-- Add comments to the columns 
comment on column SYS_CONFIG_DIMENSION.DIMENSION_CODE
  is 'άȴ';
comment on column SYS_CONFIG_DIMENSION.DIMENSION_NAME_ID
  is 'άƣ';
comment on column SYS_CONFIG_DIMENSION.ENABLED_FLAG
  is 'ñ־';
comment on column SYS_CONFIG_DIMENSION.LOOKUP_BM
  is 'ѡάȵļ¼ʱLOVʹõBM';
comment on column SYS_CONFIG_DIMENSION.LOOKUP_SCREEN
  is 'ͨLOVѡ¼ֶͨ趨ضѡ';
comment on column SYS_CONFIG_DIMENSION.DESC_LOOKUP_SQL
  is 'άֵȡ¼SQL';
comment on column SYS_CONFIG_DIMENSION.DATA_QUERY_SQL
  is 'ӸԻñлȡڸάȼ¼sqlʽ';
comment on column SYS_CONFIG_DIMENSION.ORDER_NUM
  is 'άȼ˳ţԽȼԽ';
comment on column SYS_CONFIG_DIMENSION.DESCRIPTIONS
  is '';
comment on column SYS_CONFIG_DIMENSION.BUILTIN_FLAG
  is 'ϵͳڽ־ϵͳڽάȣά治ɾ';
-- Create/Recreate primary, unique and foreign key constraints 
alter table SYS_CONFIG_DIMENSION
  add primary key (DIMENSION_CODE)
  using index;

spool off
exit
