WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_FUNCTION_GROUP.log

prompt
prompt Creating table SYS_FUNCTION_GROUP
prompt =================================
prompt
whenever sqlerror continue
drop table SYS_FUNCTION_GROUP;
whenever sqlerror exit failure rollback

create table SYS_FUNCTION_GROUP
(
  FUNCTION_GROUP_ID   NUMBER not null,
  FUNCTION_GROUP_CODE VARCHAR2(30) not null,
  START_DATE          DATE not null,
  END_DATE            DATE,
  CREATED_BY          NUMBER not null,
  CREATION_DATE       DATE not null,
  LAST_UPDATED_BY     NUMBER not null,
  LAST_UPDATE_DATE    DATE not null,
  GROUP_NAME_ID       NUMBER,
  DESCRIPTION_ID      NUMBER
);

alter table SYS_FUNCTION_GROUP
  add constraint SYS_FUNCTION_GROUP_PK primary key (FUNCTION_GROUP_ID);
  
create unique index SYS_FUNCTION_GROUP_U1 on SYS_FUNCTION_GROUP (FUNCTION_GROUP_CODE);


spool off

exit
