WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_LANGUAGES.log

prompt Dropping SYS_LANGUAGES...
whenever sqlerror continue
drop table SYS_LANGUAGES;
whenever sqlerror exit failure rollback

prompt Creating SYS_LANGUAGES...
create table SYS_LANGUAGES
(
  LANGUAGE_CODE       VARCHAR2(4) not null,
  NLS_LANGUAGE        VARCHAR2(30),
  NLS_TERRITORY       VARCHAR2(30),
  ISO_LANGUAGE        VARCHAR2(30),
  ISO_TERRITORY       VARCHAR2(30),
  NLS_CODESET         VARCHAR2(30),
  LOCAL_DATE_LANGUAGE VARCHAR2(30),
  UTF8_DATE_LANGUAGE  VARCHAR2(30),
  INSTALLED_FLAG      VARCHAR2(1),
  DESCRIPTION         VARCHAR2(240)
);
alter table SYS_LANGUAGES
  add constraint SYS_LANGUAGES_PK primary key (LANGUAGE_CODE);

prompt Loading SYS_LANGUAGES...
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('AR', 'ARABIC', 'UNITED ARAB EMIRATES', 'AR', 'AE', 'AR8ISO8859P6', 'ARABIC', 'ARABIC', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('BG', 'BULGARIAN', 'BULGARIA', 'BG', 'BG', 'CL8ISO8859P5', 'BULGARIAN', 'NUMERIC DATE LANGUAGE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('CA', 'CATALAN', 'CATALONIA', 'CA', 'CT', 'WE8ISO8859P1', 'CATALAN', 'CATALAN', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('CS', 'CZECH', 'CZECHOSLOVAKIA', 'CZ', 'CZ', 'EE8ISO8859P2', 'CZECH', 'NUMERIC DATE LANGUAGE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('D', 'GERMAN', 'GERMANY', 'DE', 'DE', 'WE8ISO8859P1', 'GERMAN', 'NUMERIC DATE LANGUAGE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('DK', 'DANISH', 'DENMARK', 'DA', 'DK', 'WE8ISO8859P1', 'DANISH', 'DANISH', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('E', 'SPANISH', 'SPAIN', 'ES', 'ES', 'WE8ISO8859P1', 'SPANISH', 'SPANISH', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('EG', 'EGYPTIAN', 'EGYPT', 'EG', 'EG', 'AR8ISO8859P6', 'EGYPTIAN', 'EGYPTIAN', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('EL', 'GREEK', 'GREECE', 'EL', 'GR', 'EL8ISO8859P7', 'GREEK', 'NUMERIC DATE LANGUAGE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('ESA', 'LATIN AMERICAN SPANISH', 'MEXICO', 'ES', 'MX', 'WE8ISO8859P1', 'LATIN AMERICAN SPANISH', 'LATIN AMERICAN SPANISH', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('F', 'FRENCH', 'FRANCE', 'FR', 'FR', 'WE8ISO8859P1', 'FRENCH', 'FRENCH', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('FRC', 'CANADIAN FRENCH', 'CANADA', 'FR', 'CA', 'WE8ISO8859P1', 'CANADIAN FRENCH', 'NUMERIC DATE LANGUAGE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('GB', 'ENGLISH', 'UNITED KINGDOM', 'EN', 'GB', 'WE8ISO8859P1', 'ENGLISH', 'ENGLISH', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('HR', 'CROATIAN', 'CROATIA', 'HR', 'YU', 'EE8ISO8859P2', 'CROATIAN', 'NUMERIC DATE LANGUAGE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('HU', 'HUNGARIAN', 'HUNGARY', 'HU', 'HU', 'EE8ISO8859P2', 'HUNGARIAN', 'NUMERIC DATE LANGUAGE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('I', 'ITALIAN', 'ITALY', 'IT', 'IT', 'WE8ISO8859P1', 'ITALIAN', 'ITALIAN', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('IS', 'ICELANDIC', 'ICELAND', 'IS', 'IS', 'WE8ISO8859P1', 'ICELANDIC', 'NUMERIC DATE LANGUAGE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('IW', 'HEBREW', 'ISRAEL', 'IW', 'IL', 'IW8ISO8859P8', 'HEBREW', 'HEBREW', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('JA', 'JAPANESE', 'JAPAN', 'JA', 'JP', 'JA16EUC', 'JAPANESE', 'JAPANESE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('KO', 'KOREAN', 'KOREA', 'KO', 'KR', 'KO16KSC5601', 'KOREAN', 'KOREAN', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('LT', 'LITHUANIAN', 'LITHUANIA', 'LT', 'LT', 'NEE8ISO8859P4', 'LITHUANIAN', 'LITHUANIAN', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('N', 'NORWEGIAN', 'NORWAY', 'NO', 'NO', 'WE8ISO8859P1', 'NORWEGIAN', 'NORWEGIAN', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('NL', 'DUTCH', 'THE NETHERLANDS', 'NL', 'NL', 'WE8ISO8859P1', 'DUTCH', 'DUTCH', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('PL', 'POLISH', 'POLAND', 'PL', 'PL', 'EE8ISO8859P2', 'POLISH', 'NUMERIC DATE LANGUAGE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('PT', 'PORTUGUESE', 'PORTUGAL', 'PT', 'PT', 'WE8ISO8859P1', 'PORTUGUESE', 'PORTUGUESE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('PTB', 'BRAZILIAN PORTUGUESE', 'BRAZIL', 'PT', 'BR', 'WE8ISO8859P1', 'BRAZILIAN PORTUGUESE', 'BRAZILIAN PORTUGUESE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('RO', 'ROMANIAN', 'ROMANIA', 'RO', 'RO', 'EE8ISO8859P2', 'ROMANIAN', 'ROMANIAN', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('RU', 'RUSSIAN', 'CIS', 'RU', 'SU', 'CL8ISO8859P5', 'RUSSIAN', 'NUMERIC DATE LANGUAGE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('S', 'SWEDISH', 'SWEDEN', 'SV', 'SE', 'WE8ISO8859P1', 'SWEDISH', 'SWEDISH', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('SF', 'FINNISH', 'FINLAND', 'FI', 'FI', 'WE8ISO8859P1', 'FINNISH', 'FINNISH', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('SK', 'SLOVAK', 'SLOVENIA', 'SK', 'SI', 'EE8ISO8859P2', 'SLOVAK', 'NUMERIC DATE LANGUAGE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('SL', 'SLOVENIAN', 'SLOVENIA', 'SL', 'SI', 'EE8ISO8859P2', 'SLOVENIAN', 'SLOVENIAN', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('TH', 'THAI', 'THAILAND', 'TH', 'TH', 'TH8TISASCII', 'NUMERIC DATE LANGUAGE', 'NUMERIC DATE LANGUAGE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('TR', 'TURKISH', 'TURKEY', 'TR', 'TR', 'WE8ISO8859P9', 'TURKISH', 'NUMERIC DATE LANGUAGE', null, null);
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('US', 'AMERICAN', 'AMERICA', 'EN', 'US', 'US7ASCII', 'AMERICAN', 'AMERICAN', 'Y', 'ENGLISH');
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('ZHS', 'SIMPLIFIED CHINESE', 'CHINA', 'ZH', 'CN', 'ZHS16CGB231280', 'NUMERIC DATE LANGUAGE', 'NUMERIC DATE LANGUAGE', 'Y', '');
insert into SYS_LANGUAGES (LANGUAGE_CODE, NLS_LANGUAGE, NLS_TERRITORY, ISO_LANGUAGE, ISO_TERRITORY, NLS_CODESET, LOCAL_DATE_LANGUAGE, UTF8_DATE_LANGUAGE, INSTALLED_FLAG, DESCRIPTION)
values ('ZHT', 'TRADITIONAL CHINESE', 'TAIWAN', 'ZH', 'TW', 'ZHT16BIG5', 'NUMERIC DATE LANGUAGE', 'NUMERIC DATE LANGUAGE', null, '');

commit;

spool off
exit