WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_MODULE.log

prompt
prompt Creating table FND_COMPANY_PROMPTS
prompt ============================
prompt

-- Create table
whenever sqlerror continue
drop table sys_module;
whenever sqlerror exit failure rollback

create table SYS_MODULE
(
  MODULE_ID        NUMBER not null,
  MODULE_CODE      VARCHAR2(6) not null,
  MODULE_NAME_ID   NUMBER,
  INSTALLED_FLAG   VARCHAR2(1) default 'N',
  CREATION_DATE    DATE not null,
  CREATED_BY       NUMBER not null,
  LAST_UPDATE_DATE DATE not null,
  LAST_UPDATED_BY  NUMBER not null
);

-- Create/Recreate primary, unique and foreign key constraints 
alter table SYS_MODULE
  add constraint SYS_MODULE_PK primary key (MODULE_ID);
  
-- Create/Recreate indexes 
create unique index SYS_MODULE_U1 on SYS_MODULE (MODULE_CODE);


spool off
exit
