WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_PARAMETER_VALUES.log

prompt
prompt Creating table SYS_PARAMETER_VALUES
prompt ===================================
prompt
whenever sqlerror continue
drop table SYS_PARAMETER_VALUES;
whenever sqlerror exit failure rollback

create table SYS_PARAMETER_VALUES
(
  MODULE_ID        NUMBER not null,
  PARAMETER_ID     NUMBER not null,
  LEVEL_ID         NUMBER not null,
  LEVEL_VALUE      NUMBER not null,
  PARAMETER_VALUE  VARCHAR2(240),
  VALUE_CODE       VARCHAR2(1000),
  VALUE_NAME       VARCHAR2(1000),
  LAST_UPDATE_DATE DATE not null,
  LAST_UPDATED_BY  NUMBER not null,
  CREATION_DATE    DATE not null,
  CREATED_BY       NUMBER not null
);

alter table SYS_PARAMETER_VALUES
  add constraint SYS_PARAMETER_VALUES_PK primary key (MODULE_ID,PARAMETER_ID,LEVEL_ID,LEVEL_VALUE);

create unique index SYS_PARAMETER_VALUES_U1 on SYS_PARAMETER_VALUES (PARAMETER_ID,LEVEL_ID,LEVEL_VALUE);


spool off

exit
