WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_PARAMETERS.log


prompt
prompt Creating table SYS_PARAMETERS
prompt =============================
prompt
whenever sqlerror continue
drop table SYS_PARAMETERS;
whenever sqlerror exit failure rollback

create table SYS_PARAMETERS
(
  MODULE_ID            NUMBER not null,
  PARAMETER_ID         NUMBER not null,
  PARAMETER_CODE       VARCHAR2(100) not null,
  VALIDATION_TYPE      VARCHAR2(100) not null,
  DESCRIPTION          VARCHAR2(2000) not null,
  USER_CHANGEABLE_FLAG VARCHAR2(1) not null,
  USER_VISIBLE_FLAG    VARCHAR2(1) not null,
  SYSTEM_ENABLED_FLAG  VARCHAR2(1) not null,
  ROLE_ENABLED_FLAG    VARCHAR2(1) not null,
  USER_ENABLED_FLAG    VARCHAR2(1) not null,
  COMPANY_ENABLED_FLAG    VARCHAR2(1) not null,
  SQL_VALIDATION       VARCHAR2(2000),
  START_DATE_ACTIVE    DATE,
  END_DATE_ACTIVE      DATE,
  PARAMETER_NAME_ID    NUMBER,
  ENCRYPT_VALUE_FLAG   VARCHAR2(1),
  APP_ENABLED_FLAG     VARCHAR2(1),
  LAST_UPDATE_DATE     DATE not null,
  LAST_UPDATED_BY      NUMBER not null,
  CREATION_DATE        DATE not null,
  CREATED_BY           NUMBER not null
);

alter table SYS_PARAMETERS
  add constraint SYS_PARAMETERS_PK primary key (PARAMETER_ID);


create unique index SYS_PARAMETERS_U1 on SYS_PARAMETERS (PARAMETER_CODE);

spool off

exit
