WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

SPOOL SYS_RAISE_APP_ERRORS.LOG


PROMPT
PROMPT CREATING TABLE SYS_RAISE_APP_ERRORS
PROMPT ===========================
PROMPT
WHENEVER SQLERROR CONTINUE
DROP TABLE SYS_RAISE_APP_ERRORS;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK

CREATE TABLE SYS_RAISE_APP_ERRORS
(
  APP_ERROR_LINE_ID       NUMBER NOT NULL,
  ERROR_NUMBER            NUMBER NOT NULL,
  MESSAGE_CODE            VARCHAR2(200) NOT NULL,
  MESSAGE                 VARCHAR2(2000),
	PACKAGE_NAME            VARCHAR2(100),
	PROCEDURE_FUNCTION_NAME VARCHAR2(30),
  MESSAGE_DATE            DATE NOT NULL,
  CREATED_BY              NUMBER 
);
ALTER TABLE SYS_RAISE_APP_ERRORS
  ADD CONSTRAINT SYS_RAISE_APP_ERRORS_PK PRIMARY KEY (APP_ERROR_LINE_ID);
CREATE INDEX SYS_RAISE_APP_ERRORS_N1 ON SYS_RAISE_APP_ERRORS (PACKAGE_NAME,MESSAGE_DATE);


PROMPT
PROMPT CREATING SEQUENCE SYS_RAISE_APP_ERRORS_S
PROMPT ==================================
PROMPT
WHENEVER SQLERROR CONTINUE
DROP SEQUENCE SYS_RAISE_APP_ERRORS_S;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK

-- CREATE SEQUENCE 
CREATE SEQUENCE SYS_RAISE_APP_ERRORS_S;
  

SPOOL OFF

EXIT

