WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_ROLE_FUNCTION_GROUP.log

prompt
prompt Creating table SYS_ROLE_FUNCTION_GROUP
prompt ======================================
prompt
whenever sqlerror continue
drop table SYS_ROLE_FUNCTION_GROUP;
whenever sqlerror exit failure rollback

create table SYS_ROLE_FUNCTION_GROUP
(
  ROLE_ID           NUMBER not null,
  FUNCTION_GROUP_ID NUMBER not null,
  LAYOUT_SEQUENCE   NUMBER,
  START_DATE        DATE not null,
  END_DATE          DATE,
  CREATED_BY        NUMBER not null,
  CREATION_DATE     DATE not null,
  LAST_UPDATED_BY   NUMBER not null,
  LAST_UPDATE_DATE  DATE not null
);

alter table SYS_ROLE_FUNCTION_GROUP
  add constraint SYS_ROLE_FUNCTION_GROUP_PK primary key (ROLE_ID,FUNCTION_GROUP_ID);

create unique index SYS_ROLE_FUNCTION_GROUP_U1 
 on SYS_ROLE_FUNCTION_GROUP (ROLE_ID,FUNCTION_GROUP_ID,START_DATE,END_DATE);


spool off

exit
