WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_RUNTIME_EXCEPTION_LOG.log

prompt
prompt Creating table SYS_RUNTIME_EXCEPTION_LOG
prompt ============================
prompt
whenever sqlerror continue
drop table SYS_RUNTIME_EXCEPTION_LOG;
whenever sqlerror exit failure rollback

create table SYS_RUNTIME_EXCEPTION_LOG
(
  EXCEPTION_ID      NUMBER not null,
  EXCEPTION_TYPE    VARCHAR2(200),
  EXCEPTION_MESSAGE VARCHAR2(2000),
  REQUEST_ID        VARCHAR2(100),
  CONTEXT_DUMP      CLOB,
  ROOT_STACK_TRACE  CLOB,
  FULL_STACK_TRACE  CLOB,
  SESSION_ID        NUMBER,
  CREATION_TIME     DATE default sysdate
)
;
alter table SYS_RUNTIME_EXCEPTION_LOG
  add primary key (EXCEPTION_ID);
create index SYS_RUNTIME_EXCEPTION_LOG_IDX1 on SYS_RUNTIME_EXCEPTION_LOG (REQUEST_ID);
create index SYS_RUNTIME_EXCEPTION_LOG_IDX2 on SYS_RUNTIME_EXCEPTION_LOG (EXCEPTION_TYPE);

spool off

exit