WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_RUNTIME_REQ_REC_ARCHIVE.log

prompt
prompt Creating table SYS_RUNTIME_REQ_REC_ARCHIVE
prompt ============================
prompt

whenever sqlerror continue
drop table SYS_RUNTIME_REQ_REC_ARCHIVE;
whenever sqlerror exit failure rollback

create table SYS_RUNTIME_REQ_REC_ARCHIVE
(
  request_id                  VARCHAR2(100) not null,
  enter_time                  DATE,
  exit_time                   DATE,
  duration                    NUMBER,
  is_success                  VARCHAR2(5),
  client_address              VARCHAR2(100),
  user_agent                  VARCHAR2(200),
  client_os_family            VARCHAR2(50),
  client_os                   VARCHAR2(50),
  client_os_version           VARCHAR2(50),
  client_browser_family       VARCHAR2(50),
  client_browser              VARCHAR2(50),
  client_browser_version      VARCHAR2(50),
  client_renderer_kit         VARCHAR2(50),
  client_renderer_kit_version VARCHAR2(50),
  client_platform             VARCHAR2(200),
  accept_language             VARCHAR2(300),
  server_name                 VARCHAR2(50),
  server_port                 NUMBER,
  context_path                VARCHAR2(100),
  url                         VARCHAR2(300),
  query_string                VARCHAR2(1000),
  referer                     VARCHAR2(300),
  session_id                  NUMBER,
  user_id                     NUMBER
);

alter table SYS_RUNTIME_REQ_REC_ARCHIVE
  add primary key (REQUEST_ID)
  using index ;

spool off

exit
