WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool sys_runtime_req_summary.log



prompt
prompt Creating table sys_runtime_req_summary
prompt ====================================
prompt
whenever sqlerror continue
drop table sys_runtime_req_summary;
whenever sqlerror exit failure rollback

create table sys_runtime_req_summary
(
       id               number,
       day              date   not null,
       visits           number not null,
       med_dur_screen   number not null,
       med_dur_svc      number not null,
       med_dur_query    number not null,
       max_dur_screen   number not null,
       max_dur_svc      number not null,
       max_dur_query    number not null,
       min_dur_screen   number not null,
       min_dur_svc      number not null,
       min_dur_query    number not null,
       avg_dur_screen   number not null,
       avg_dur_svc      number not null,
       avg_dur_query    number not null,
       ratio_screen     number not null,
       ratio_svc        number not null,
       ratio_query      number not null
);
create index req_summary_idx1 on sys_runtime_req_summary(day);
create index req_summary_idx2 on sys_runtime_req_summary(med_dur_screen);
create index req_summary_idx3 on sys_runtime_req_summary(med_dur_svc);
create index req_summary_idx4 on sys_runtime_req_summary(med_dur_query);
alter table sys_runtime_req_summary add primary key(id);



spool off
exit