WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_RUNTIME_REQUEST_RECORD.log

prompt
prompt Creating table SYS_RUNTIME_REQUEST_RECORD
prompt ============================
prompt
whenever sqlerror continue
drop table SYS_RUNTIME_REQUEST_RECORD;
whenever sqlerror exit failure rollback

create table SYS_RUNTIME_REQUEST_RECORD
(
  REQUEST_ID                  VARCHAR2(100) not null,
  ENTER_TIME                  DATE,
  EXIT_TIME                   DATE,
  DURATION                    NUMBER,
  IS_SUCCESS                  VARCHAR2(5),
  CLIENT_ADDRESS              VARCHAR2(100),
  USER_AGENT                  VARCHAR2(200),
  CLIENT_OS_FAMILY            VARCHAR2(50),
  CLIENT_OS                   VARCHAR2(50),
  CLIENT_OS_VERSION           VARCHAR2(50),
  CLIENT_BROWSER_FAMILY       VARCHAR2(50),
  CLIENT_BROWSER              VARCHAR2(50),
  CLIENT_BROWSER_VERSION      VARCHAR2(50),
  CLIENT_RENDERER_KIT         VARCHAR2(50),
  CLIENT_RENDERER_KIT_VERSION VARCHAR2(50),
  CLIENT_PLATFORM             VARCHAR2(200),
  ACCEPT_LANGUAGE             VARCHAR2(300),
  SERVER_NAME                 VARCHAR2(50),
  SERVER_PORT                 NUMBER,
  CONTEXT_PATH                VARCHAR2(100),
  URL                         VARCHAR2(300),
  QUERY_STRING                VARCHAR2(1000),
  REFERER                     VARCHAR2(300),
  SESSION_ID                  NUMBER,
  USER_ID                     NUMBER
)
;
alter table SYS_RUNTIME_REQUEST_RECORD
  add primary key (REQUEST_ID);
  

spool off

exit