WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_SESSION.log

prompt
prompt Creating table SYS_SESSION
prompt ============================
prompt
whenever sqlerror continue
drop table SYS_SESSION;
whenever sqlerror exit failure rollback

-- Create table
create table SYS_SESSION
(
  SESSION_ID           NUMBER not null,
  ENCRYPTED_SESSION_ID VARCHAR2(100) not null,
  USER_ID              NUMBER not null,
  ROLE_ID              NUMBER,
  COMPANY_ID           NUMBER,
  USER_LANGUAGE        VARCHAR2(4) not null,
  APP_IP_ADDRESS       VARCHAR2(30),
  CLIENT_IP_ADDRESS    VARCHAR2(30),
  MACHINE_SERIAL       VARCHAR2(100) default 'UNDIFINE' not null,
  LOGIN_TIME           DATE default SYSDATE not null,
  LOGOUT_TIME          DATE,
  LAST_ACTIVE_TIME     DATE,
  NOTE                 VARCHAR2(2000),
  LAST_UPDATE_DATE     DATE not null,
  LAST_UPDATED_BY      NUMBER not null,
  CREATION_DATE        DATE not null,
  CREATED_BY           NUMBER not null
);
-- Create/Recreate primary, unique and foreign key constraints 
alter table SYS_SESSION
  add constraint SYS_SESSION_PK primary key (SESSION_ID);
-- Create/Recreate indexes 
create index SYS_SESSION_N1 on SYS_SESSION (USER_ID, ROLE_ID, COMPANY_ID);
create unique index SYS_SESSION_U1 on SYS_SESSION (ENCRYPTED_SESSION_ID);
  
spool off
 
exit
