WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;


spool SYS_SSO_LOGIN_SESSION.log

prompt
prompt Creating table SYS_SSO_LOGIN_SESSION
prompt ================================
prompt
whenever sqlerror continue
drop table SYS_SSO_LOGIN_SESSION;
whenever sqlerror exit failure rollback

-- Create table
create table SYS_SSO_LOGIN_SESSION
(
  SSO_LOGIN_SESSION_ID     NUMBER not null,
  ENCRYPTED_SSO_SESSION_ID VARCHAR2(100) not null,
  USER_ID                  NUMBER not null,
  ROLE_ID                  NUMBER,
  COMPANY_ID               NUMBER,
  FUNCTION_ID              NUMBER not null,
  USER_LANGUAGE            VARCHAR2(4) not null,
  ENCRYPTED_PASSWORD       VARCHAR2(100),
  APP_IP_ADDRESS           VARCHAR2(30),
  CLIENT_IP_ADDRESS        VARCHAR2(30),
  MACHINE_SERIAL           VARCHAR2(100) default 'UNDIFINE',
  LOGIN_TIME               DATE default SYSDATE not null,
  NOTE                     VARCHAR2(2000),
  LAST_UPDATE_DATE         DATE not null,
  LAST_UPDATED_BY          NUMBER not null,
  CREATION_DATE            DATE not null,
  CREATED_BY               NUMBER not null
);
-- Create/Recreate primary, unique and foreign key constraints 
alter table SYS_SSO_LOGIN_SESSION
  add constraint SYS_SSO_LOGIN_SESSION_PK primary key (SSO_LOGIN_SESSION_ID);
-- Create/Recreate indexes 
create index SYS_SSO_LOGIN_SESSION_N1 on SYS_SSO_LOGIN_SESSION (USER_ID, ROLE_ID, COMPANY_ID);
create unique index SYS_SSO_LOGIN_SESSION_U1 on SYS_SSO_LOGIN_SESSION (ENCRYPTED_SSO_SESSION_ID);

spool off
exit