WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_USER.log

prompt
prompt Creating table SYS_USER
prompt =======================
prompt
whenever sqlerror continue
drop table SYS_USER;
whenever sqlerror exit failure rollback

create table SYS_USER
(
  USER_ID                       NUMBER not null,
  USER_NAME                     VARCHAR2(100) not null,
  ENCRYPTED_FOUNDATION_PASSWORD VARCHAR2(100) not null,
  ENCRYPTED_USER_PASSWORD       VARCHAR2(100) not null,
  START_DATE                    DATE not null,
  END_DATE                      DATE,
  LAST_LOGON_DATE               DATE,
  DESCRIPTION                   VARCHAR2(240),
  PASSWORD_LIFESPAN_DAYS        NUMBER,
  PASSWORD_LIFESPAN_ACCESS      NUMBER,
  EMPLOYEE_ID                   NUMBER,
  CUSTOMER_ID                   NUMBER,
  VENDER_ID                     NUMBER,
  FROZEN_FLAG										VARCHAR2(1),
  FROZEN_DATE										DATE,
  PASSWORD_START_DATE						DATE,
  MENU_TYPE                     VARCHAR2(1) default 'L',
  LAST_UPDATE_DATE              DATE not null,
  LAST_UPDATED_BY               NUMBER not null,
  CREATION_DATE                 DATE not null,
  CREATED_BY                    NUMBER not null
);

alter table SYS_USER
  add constraint SYS_USER_PK primary key (USER_ID);
  
create index SYS_USER_N1 on SYS_USER (EMPLOYEE_ID);

create unique index SYS_USER_U1 on SYS_USER (USER_NAME);


spool off

exit
