WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_USER_LOGIN_DETAILS.log


prompt
prompt Creating table SYS_USER_LOGIN_DETAILS
prompt =======================
prompt
whenever sqlerror continue
drop table SYS_USER_LOGIN_DETAILS;
whenever sqlerror exit failure rollback

-- Create table
create table SYS_USER_LOGIN_DETAILS
(
  DETAIL_LINE_ID   NUMBER not null,
  LOGIN_ID         NUMBER not null,
  FUNCTION_ID      NUMBER,
  ACTION_CODE      VARCHAR2(30) not null,
  IN_TIME          DATE default sysdate not null,
  OUT_TIME         DATE ,
  DESCRIPTION      VARCHAR2(2000),
  LAST_UPDATE_DATE DATE not null,
  LAST_UPDATED_BY  NUMBER not null,
  CREATION_DATE    DATE not null,
  CREATED_BY       NUMBER not null
);
-- Create/Recreate primary, unique and foreign key constraints 
alter table SYS_USER_LOGIN_DETAILS
  add constraint SYS_USER_LOGIN_DETAILS_PK primary key (DETAIL_LINE_ID);
-- Create/Recreate indexes 
create index SYS_USER_LOGIN_DETAILS_N1 on SYS_USER_LOGIN_DETAILS (LOGIN_ID);


spool off

exit
