WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_USER_LOGINS.log

prompt
prompt Creating table SYS_USER_LOGINS
prompt =======================
prompt
whenever sqlerror continue
drop table SYS_USER_LOGINS;
whenever sqlerror exit failure rollback

-- Create table
create table SYS_USER_LOGINS
(
  LOGIN_ID          NUMBER not null,
  USER_ID           NUMBER not null,
  ROLE_ID           NUMBER not null,
  COMPANY_ID        NUMBER ,
  SESSION_ID        NUMBER not null,
  ENCRYPTED_SESSION_ID VARCHAR2(100),
  NLS_LANGUAGE      VARCHAR2(100),
  MACHINE_SERIAL    VARCHAR2(100) default 'UNDIFINE' not null,
  CLIENT_IP_ADDRESS VARCHAR2(30),
  APP_IP_ADDRESS    VARCHAR2(30),
  LOGIN_TIME        DATE default SYSDATE not null,
  LOGOUT_TIME       DATE,
  LAST_ACTIVE_TIME  DATE,
  DESCRIPTION       VARCHAR2(2000),
  LAST_UPDATE_DATE  DATE not null,
  LAST_UPDATED_BY   NUMBER not null,
  CREATION_DATE     DATE not null,
  CREATED_BY        NUMBER not null
);
-- Create/Recreate primary, unique and foreign key constraints 
alter table SYS_USER_LOGINS
  add constraint SYS_USER_LOGINS_PK primary key (LOGIN_ID);
-- Create/Recreate indexes 
create index SYS_USER_LOGINS_N1 on SYS_USER_LOGINS (USER_ID, ROLE_ID, COMPANY_ID);
create index SYS_USER_LOGINS_N2 on SYS_USER_LOGINS (SESSION_ID);
create index SYS_USER_LOGINS_N3 on SYS_USER_LOGINS (ENCRYPTED_SESSION_ID);


spool off

exit
