WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_USER_PROMPTS.log


prompt
prompt Creating table SYS_USER_PROMPTS
prompt ============================
prompt
whenever sqlerror continue
drop table SYS_USER_PROMPTS;
whenever sqlerror exit failure rollback

-- Create table
create table SYS_USER_PROMPTS
(
  PROMPT_ID        NUMBER not null,
  USER_ID          NUMBER not null,
  PROMPT_CODE      VARCHAR2(100) not null,
  LANGUAGE         VARCHAR2(4) not null,
  DESCRIPTION      VARCHAR2(200) not null,
  LAST_UPDATE_DATE DATE not null,
  LAST_UPDATED_BY  NUMBER not null,
  CREATION_DATE    DATE not null,
  CREATED_BY       NUMBER not null
);
-- Create/Recreate primary, unique and foreign key constraints 
alter table SYS_USER_PROMPTS
  add constraint SYS_USER_PROMPTS_PK primary key (PROMPT_ID,USER_ID);
-- Create/Recreate indexes 
create unique index SYS_USER_PROMPTS_U1 on SYS_USER_PROMPTS (USER_ID, PROMPT_CODE, LANGUAGE);


spool off

exit
