WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_USER_PWD_CHANGED_LOGS.log

prompt
prompt Creating table SYS_USER_PWD_CHANGED_LOGS
prompt ===================================
prompt
whenever sqlerror continue
drop table SYS_USER_PWD_CHANGED_LOGS;
whenever sqlerror exit failure rollback

-- Create table
create table SYS_USER_PWD_CHANGED_LOGS
(
  CHANGED_USER_ID   NUMBER not null,
  MODIFY_TYPE       VARCHAR2(30) not null,
  IP_ADDRESS        VARCHAR2(30) not null,
  ORIGINAL_PASSWORD VARCHAR2(100) not null,
  NEW_PASSWORD      VARCHAR2(100) not null,
  CREATED_BY        NUMBER not null,
  CREATION_DATE     DATE not null,
  LAST_UPDATED_BY   NUMBER not null,
  LAST_UPDATE_DATE  DATE not null
);
-- Create/Recreate indexes 
create index SSYS_USER_PWD_CHANGED_LOGS_N1 on SYS_USER_PWD_CHANGED_LOGS (CHANGED_USER_ID, MODIFY_TYPE);


spool off

exit
