WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;


spool FND_COMPANIES_VL.log

prompt
prompt Creating view FND_COMPANIES_VL
prompt ==============================
prompt
CREATE OR REPLACE FORCE VIEW FND_COMPANIES_VL as
SELECT T.COMPANY_ID,
			 T.COMPANY_CODE,
			 T.COMPANY_ICON,
			 A.DESCRIPTION_TEXT AS COMPANY_SHORT_NAME,
			 B.DESCRIPTION_TEXT AS COMPANY_FULL_NAME,
			 T.COMPANY_TYPE,
			 T.SET_OF_BOOKS_ID,
       T.COMPANY_LEVEL_ID,
       T.CHIEF_POSITION_ID,
       T.PARENT_COMPANY_ID,
			 T.ADDRESS,
			 T.START_DATE_ACTIVE,
			 T.END_DATE_ACTIVE,
			 T.LAST_UPDATE_DATE,
			 T.LAST_UPDATED_BY,
			 T.CREATION_DATE,
			 T.CREATED_BY
	FROM FND_COMPANIES T, FND_DESCRIPTIONS A, FND_DESCRIPTIONS B
 WHERE T.COMPANY_SHORT_NAME_ID = A.DESCRIPTION_ID(+)
	 AND A.LANGUAGE(+) = USERENV('LANG')
	 AND A.REF_TABLE(+) = 'FND_COMPANIES'
	 AND A.REF_FIELD(+) = 'COMPANY_SHORT_NAME_ID'
	 AND T.COMPANY_FULL_NAME_ID = B.DESCRIPTION_ID(+)
	 AND B.LANGUAGE(+) = USERENV('LANG')
	 AND B.REF_TABLE(+) = 'FND_COMPANIES'
	 AND B.REF_FIELD(+) = 'COMPANY_FULL_NAME_ID'
/


spool off


exit
