WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_ROLE_VL.log


prompt
prompt Creating view SYS_ROLE_VL
prompt ========================================
prompt

CREATE OR REPLACE FORCE VIEW SYS_ROLE_VL as
select a.role_id,
			 a.role_code,
			 b.description_text description,
			 c.description_text role_name,
			 a.start_date,
			 a.end_date,
			 a.created_by,
			 a.creation_date,
			 a.last_updated_by,
			 a.last_update_date
	from sys_role a, fnd_descriptions b, fnd_descriptions c
 where b.language(+) = userenv('lang')
	 and a.description_id = b.description_id(+)
	 and b.ref_table(+) = 'SYS_ROLE'
	 and b.ref_field(+) = 'DESCRIPTION_ID'
	 and c.language(+) = userenv('lang')
	 and a.role_name_id = c.description_id(+)
	 and c.ref_table(+) = 'SYS_ROLE'
	 and c.ref_field(+) = 'ROLE_NAME_ID'
/


spool off

exit
