package com.hand.mas.ant.task;
import java.io.File;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class FileSizeTask extends Task {
	String property;
	File file;

	@Override
	public void execute() {
		if (property == null) {
			throw new BuildException("the property is null");
		} else if (file == null) {
			throw new BuildException("the file is null");
		} else if (!file.exists()) {
			throw new BuildException("the file not exist");
		}

		Long size = file.length();
		log("the file size is " + size);
		getProject().setNewProperty(property, "" + size);
	}

	public void setProperty(String property) {
		this.property = property;
	}

	public void setFile(File file) {
		this.file = file;
	}
}
