package com.hand.mas.installer;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Scanner;

import com.hand.mas.ant.util.LogUtil;
import com.hand.mas.ant.util.SysExcUtil;

public class Installer {
	
	String []args;
	Boolean errorFlag = false;
	Boolean appExitFlag = false;
	
	private void install() {
		try {
			Scanner sc = new Scanner(System.in);
			Properties prop = new Properties();
			prop.load(new FileInputStream("installer.properties"));
			PromptInfo prompt = new PromptInfo();
			prompt.printWelcomeInfo();
			prompt.printEnterInfo();
		
			String scStr = sc.nextLine();
			if(scStr.equals("1")){
				System.out.println("Please enter the cvs root:(default:" + prop.getProperty("CVS_ROOT")+")" );
				String cvsRoot = sc.nextLine();
				if(!cvsRoot.equals("")){
					prop.setProperty("CVS_ROOT", cvsRoot);
				}
				System.out.println("Please enter the cvs name:(default:" + prop.getProperty("CVS_NAME")+")" );
				String cvsName = sc.nextLine();
				if(!cvsName.equals("")){
					prop.setProperty("CVS_NAME", cvsName);
				}
				prop.store(new FileOutputStream("installer.properties"), null);
				Process pro = Runtime.getRuntime().exec(SysExcUtil.getCmd(new String[]{"ant","cvsAutoIns"}));
				processPrint(pro.getInputStream(),pro.getErrorStream());
			}else if(scStr.equals("2")){
				System.out.println("Please enter the db sid:(default:" + prop.getProperty("DB_SID")+")" );
				String dbSid = sc.nextLine();
				if(!dbSid.equals("")){
					prop.setProperty("DB_SID", dbSid);
				}
				System.out.println("Please enter the db host:(default:" + prop.getProperty("DB_HOST")+")" );
				String dbHost = sc.nextLine();
				if(!dbHost.equals("")){
					prop.setProperty("DB_HOST", dbHost);
				}
				System.out.println("Please enter the db port:(default:" + prop.getProperty("DB_PORT")+")" );
				String dbPort = sc.nextLine();
				if(!dbPort.equals("")){
					prop.setProperty("DB_PORT", dbPort);
				}
				System.out.println("Please enter the db user:(default:" + prop.getProperty("DB_USER")+")" );
				String dbUser = sc.nextLine();
				if(!dbUser.equals("")){
					prop.setProperty("DB_USER", dbUser);
				}
				System.out.println("Please enter the db password:(default:" + prop.getProperty("DB_PASS")+")" );
				String dbPass = sc.nextLine();
				if(!dbPass.equals("")){
					prop.setProperty("DB_PASS", dbPass);
				}
				System.out.println("Please enter the tns name:(default:" + prop.getProperty("TNSNAME")+")" );
				String tnsName = sc.nextLine();
				if(!tnsName.equals("")){
					prop.setProperty("TNSNAME", tnsName);
				}
				System.out.println("Please enter the super db user:(default:" + prop.getProperty("SUPER_DB_USER")+")" );
				String superDbUser = sc.nextLine();
				if(!superDbUser.equals("")){
					prop.setProperty("SUPER_DB_USER", superDbUser);
				}
				System.out.println("Please enter the super db pass:(default:" + prop.getProperty("SUPER_DB_PASS")+")" );
				String superDbPass = sc.nextLine();
				if(!superDbPass.equals("")){
					prop.setProperty("SUPER_DB_PASS", superDbPass);
				}
				System.out.println("Please enter the table space:(default:" + prop.getProperty("TABLE_SPACE")+")" );
				String tableSpace = sc.nextLine();
				if(!tableSpace.equals("")){
					prop.setProperty("TABLE_SPACE", tableSpace);
				}
				prop.store(new FileOutputStream("installer.properties"), null);
				Process pro = Runtime.getRuntime().exec(SysExcUtil.getCmd(new String[]{"ant","dbAutoIns"}));
				processPrint(pro.getInputStream(),pro.getErrorStream());
			}else if(scStr.equals("3")){
				System.out.println("Please enter the web home:(default:" + prop.getProperty("WEB_HOME")+")" );
				String webHome = sc.nextLine();
				if(!webHome.equals("")){
					prop.setProperty("WEB_HOME", webHome);
				}
				System.out.println("Please enter the amq ip:(default:" + prop.getProperty("AMQ_IP")+")" );
				String amqIp = sc.nextLine();
				if(!amqIp.equals("")){
					prop.setProperty("AMQ_IP", amqIp);
				}
				System.out.println("Please enter the amq port:(default:" + prop.getProperty("AMQ_PORT")+")" );
				String amqPort = sc.nextLine();
				if(!amqPort.equals("")){
					prop.setProperty("AMQ_PORT", amqPort);
				}
				System.out.println("Please enter the db sid:(default:" + prop.getProperty("DB_SID")+")" );
				String dbSid = sc.nextLine();
				if(!dbSid.equals("")){
					prop.setProperty("DB_SID", dbSid);
				}
				System.out.println("Please enter the db host:(default:" + prop.getProperty("DB_HOST")+")" );
				String dbHost = sc.nextLine();
				if(!dbHost.equals("")){
					prop.setProperty("DB_HOST", dbHost);
				}
				System.out.println("Please enter the db port:(default:" + prop.getProperty("DB_PORT")+")" );
				String dbPort = sc.nextLine();
				if(!dbPort.equals("")){
					prop.setProperty("DB_PORT", dbPort);
				}
				System.out.println("Please enter the db user:(default:" + prop.getProperty("DB_USER")+")" );
				String dbUser = sc.nextLine();
				if(!dbUser.equals("")){
					prop.setProperty("DB_USER", dbUser);
				}
				System.out.println("Please enter the db password:(default:" + prop.getProperty("DB_PASS")+")" );
				String dbPass = sc.nextLine();
				if(!dbPass.equals("")){
					prop.setProperty("DB_PASS", dbPass);
				}
				System.out.println("Please enter the tns name:(default:" + prop.getProperty("TNSNAME")+")" );
				String tnsName = sc.nextLine();
				if(!tnsName.equals("")){
					prop.setProperty("TNSNAME", tnsName);
				}
				System.out.println("Please enter the java home:(default:" + prop.getProperty("JAVA_HOME")+")" );
				String javaHome = sc.nextLine();
				if(!javaHome.equals("")){
					prop.setProperty("JAVA_HOME", javaHome);
				}
				System.out.println("Please enter the shutdown file:(default:" + prop.getProperty("SHUTDOWN_FILE")+")" );
				String shutdownFile = sc.nextLine();
				if(!shutdownFile.equals("")){
					prop.setProperty("SHUTDOWN_FILE", shutdownFile);
				}
				System.out.println("Please enter the startup file:(default:" + prop.getProperty("STARTUP_FILE")+")" );
				String startupFile = sc.nextLine();
				if(!startupFile.equals("")){
					prop.setProperty("STARTUP_FILE", startupFile);
				}
				System.out.println("Please enter the http port of tomcat birt:(default:" + prop.getProperty("TOMCAT_BIRT_PORT2")+ ")" );
				String tomcatHttpPort = sc.nextLine();
				if(!tomcatHttpPort.equals("")){
					prop.setProperty("TOMCAT_BIRT_PORT2", tomcatHttpPort);
				}
				prop.store(new FileOutputStream("installer.properties"), null);
				Process pro = Runtime.getRuntime().exec(SysExcUtil.getCmd(new String[]{"ant","webAutoIns"}));
				processPrint(pro.getInputStream(),pro.getErrorStream());
			}else if(scStr.equals("4")){
				Process pro = Runtime.getRuntime().exec(SysExcUtil.getCmd(new String[]{"ant"}));
				processPrint(pro.getInputStream(),pro.getErrorStream());
			}else if(scStr.equals("5")){
				boolean continueFlag = true;
				String startUpStr = "";
				String shutDownStr = "";
				System.out.println("Please enter the tomcat you want install:(default:" + prop.getProperty("TOMCAT_PATH")+")" );
				String tomcatPath = sc.nextLine();
				if(!tomcatPath.equals("")){
					prop.setProperty("TOMCAT_PATH", tomcatPath);
				}
				System.out.println("Please enter the tomcat home:(default:" + prop.getProperty("TOMCAT_HOME")+")" );
				String tomcatHome = sc.nextLine();
				if(!tomcatHome.equals("")){
					prop.setProperty("TOMCAT_HOME", tomcatHome);
				}
				System.out.println("Please enter the web home:(default:" + prop.getProperty("WEB_HOME")+")" );
				String webHome = sc.nextLine();
				if(!webHome.equals("")){
					prop.setProperty("WEB_HOME", webHome);
				}
				for(int i = 1 ; i < 9; i ++){
					if(continueFlag){
						System.out.println("Install tomcat  " + i + ":(default:" + prop.getProperty("TOMCAT" + i + "_FLAG")+")" );
						String tomcatFlag = sc.nextLine();
						if(!tomcatFlag.equals("")){
							prop.setProperty("TOMCAT" + i + "_FLAG", tomcatFlag);
						}
						if(tomcatFlag.equals("false") || (prop.getProperty("TOMCAT" + i + "_FLAG").equals("false") && tomcatFlag.equals(""))){
							continueFlag = false;
							continue;
						}
						System.out.println("Please enter the shutdown port of tomcat " + i + ":(default:" + prop.getProperty("TOMCAT" + i + "_PORT1")+ ")" );
						String tomcatShutdownPort = sc.nextLine();
						if(!tomcatShutdownPort.equals("")){
							prop.setProperty("TOMCAT" + i + "_PORT1", tomcatShutdownPort);
						}
						System.out.println("Please enter the http port of tomcat " + i + ":(default:" + prop.getProperty("TOMCAT" + i + "_PORT2")+ ")" );
						String tomcatHttpPort = sc.nextLine();
						if(!tomcatHttpPort.equals("")){
							prop.setProperty("TOMCAT" + i + "_PORT2", tomcatHttpPort);
						}
						System.out.println("Please enter the ajp port of tomcat " + i + ":(default:" + prop.getProperty("TOMCAT" + i + "_PORT3")+ ")" );
						String tomcatAjpPort = sc.nextLine();
						if(!tomcatAjpPort.equals("")){
							prop.setProperty("TOMCAT" + i + "_PORT3", tomcatAjpPort);
						}
						startUpStr += (tomcatHome.equals("") ? prop.getProperty("TOMCAT_HOME") : tomcatHome) + "/tomcat_" + i + "/bin/startup.sh\n";
						shutDownStr += (tomcatHome.equals("") ? prop.getProperty("TOMCAT_HOME") : tomcatHome) + "/tomcat_" + i + "/bin/shutdown.sh\n";
					}else{
						prop.setProperty("TOMCAT" + i + "_FLAG", "false");
					}
				}
				System.out.println("Install birt tomcat :(default:" + prop.getProperty("TOMCAT_BIRT_FLAG")+")" );
				String tomcatBirtFlag = sc.nextLine();
				if(!tomcatBirtFlag.equals("")){
					prop.setProperty("TOMCAT_BIRT_FLAG", tomcatBirtFlag);
				}
				if(tomcatBirtFlag.equals("true") || (prop.getProperty("TOMCAT_BIRT_FLAG").equals("true") && tomcatBirtFlag.equals(""))){
					System.out.println("Please enter the shutdown port of tomcat birt:(default:" + prop.getProperty("TOMCAT_BIRT_PORT1")+ ")" );
					String tomcatShutdownPort = sc.nextLine();
					if(!tomcatShutdownPort.equals("")){
						prop.setProperty("TOMCAT_BIRT_PORT1", tomcatShutdownPort);
					}
					System.out.println("Please enter the http port of tomcat birt:(default:" + prop.getProperty("TOMCAT_BIRT_PORT2")+ ")" );
					String tomcatHttpPort = sc.nextLine();
					if(!tomcatHttpPort.equals("")){
						prop.setProperty("TOMCAT_BIRT_PORT2", tomcatHttpPort);
					}
					System.out.println("Please enter the ajp port of tomcat birt:(default:" + prop.getProperty("TOMCAT_BIRT_PORT3")+ ")" );
					String tomcatAjpPort = sc.nextLine();
					if(!tomcatAjpPort.equals("")){
						prop.setProperty("TOMCAT_BIRT_PORT3", tomcatAjpPort);
					}
				}
				prop.setProperty("SHUTDOWN_FILE", shutDownStr);
				prop.setProperty("STARTUP_FILE", startUpStr);
				prop.store(new FileOutputStream("installer.properties"), null);
				Process pro = Runtime.getRuntime().exec(SysExcUtil.getCmd(new String[]{"ant","copyTomcat"}));
				processPrint(pro.getInputStream(),pro.getErrorStream());
			}else if(scStr.equals("6")){
				System.out.println("Please enter the mail host:(default:" + prop.getProperty("MAIL_HOST")+")" );
				String mailHost = sc.nextLine();
				if(!mailHost.equals("")){
					prop.setProperty("MAIL_HOST", mailHost);
				}
				System.out.println("Please enter the mail user:(default:" + prop.getProperty("MAIL_USER")+")" );
				String mailUser = sc.nextLine();
				if(!mailUser.equals("")){
					prop.setProperty("MAIL_USER", mailUser);
				}
				System.out.println("Please enter the mail pass:(default:" + prop.getProperty("MAIL_PASS")+")" );
				String mailPass = sc.nextLine();
				if(!mailPass.equals("")){
					prop.setProperty("MAIL_PASS", mailPass);
				}
				System.out.println("Please enter the mail port:(default:" + prop.getProperty("MAIL_PORT")+")" );
				String mailPort = sc.nextLine();
				if(!mailPort.equals("")){
					prop.setProperty("MAIL_PORT", mailPort);
				}
				System.out.println("Please enter the mail to:(default:" + prop.getProperty("MAIL_TO")+")" );
				String mailTo = sc.nextLine();
				if(!mailTo.equals("")){
					prop.setProperty("MAIL_TO", mailTo);
				}
				System.out.println("Please enter the mail from:(default:" + prop.getProperty("MAIL_FROM")+")" );
				String mailFrom = sc.nextLine();
				if(!mailFrom.equals("")){
					prop.setProperty("MAIL_FROM", mailFrom);
				}
				System.out.println("Please enter the mail subject:(default:" + prop.getProperty("MAIL_SUBJECT")+")" );
				String mailSubject = sc.nextLine();
				if(!mailSubject.equals("")){
					prop.setProperty("MAIL_SUBJECT", mailSubject);
				}
				prop.store(new FileOutputStream("installer.properties"), null);
				Process pro = Runtime.getRuntime().exec(SysExcUtil.getCmd(new String[]{"ant","webAutoIns"}));
				processPrint(pro.getInputStream(),pro.getErrorStream());
			}else if(scStr.equals("q")){
				System.out.println("exit Install!");
				return ;
			}
			install();
		} catch (IOException e) {
			System.out.println("The installer.properties not exist!");
			e.printStackTrace();
		}
	}
	
	private void processPrint(InputStream is,InputStream errIs){
		Scanner sc = new Scanner(is);
		while(sc.hasNext()){
			System.out.println(sc.nextLine());
		}
	}
	
	class ExecPrint implements Runnable{
		InputStream is ;
		String printType;
		Installer ins ;
		
		public ExecPrint(InputStream is,String  printType,Installer ins){
			this.is = is;
			this.printType = printType;
			this.ins = ins;
		}
		
		public void run(){
			Scanner sc = new Scanner(is);
			String str = "";
			if(this.printType.equals("error")){
				while(!Thread.currentThread().isInterrupted()&&!appExitFlag && sc.hasNext()){
					System.out.println(sc.nextLine());
					str += sc.nextLine();
				}
				ins.setErrorFlag(true);
			}else{
				while(!Thread.currentThread().isInterrupted()&&!errorFlag && sc.hasNext()){
					System.out.println(sc.nextLine());
					str += sc.nextLine();
				}
				ins.setAppExitFlag(true);
			}
		}
	}

	class PromptInfo {

		void printWelcomeInfo() {
			if(args != null && args[0] != null ){
				System.out.println(args[0]);
			}else{
				System.out.println("Welcome to install HEC2.0");
			}
		}

		void printEnterInfo() {
			System.out.println("enter your selection!");
			System.out.println("1.update cvs");
			System.out.println("2.Install Database");
			System.out.println("3.Install HEC2.0");
			System.out.println("4.Auto Install");
			System.out.println("5.Install Tomcat");
			System.out.println("enter q to exit!");
		}
	}

	public static void main(String args[]) {
		LogUtil.clearLog();
		Installer inst = new Installer();
		inst.args = args;
		inst.install();
	}

	public void setErrorFlag(Boolean errorFlag) {
		this.errorFlag = errorFlag;
	}

	public void setAppExitFlag(Boolean appExitFlag) {
		this.appExitFlag = appExitFlag;
	}
}
