package com.hand.mas.updater;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Scanner;

import com.hand.mas.ant.util.LogUtil;
import com.hand.mas.ant.util.SysExcUtil;

public class Updater {
	
	String []args;
	Boolean errorFlag = false;
	Boolean appExitFlag = false;
	
	private void install() {
		try {
			Scanner sc = new Scanner(System.in);
			Properties prop = new Properties();
			prop.load(new FileInputStream("installer.properties"));
			PromptInfo prompt = new PromptInfo();
			prompt.printWelcomeInfo();
			prompt.printEnterInfo();
		
			String scStr = sc.nextLine();
			if(scStr.equals("1")){
				System.out.println("Please enter the db user:(default:" + prop.getProperty("DB_USER")+")" );
				String dbUser = sc.nextLine();
				if(!dbUser.equals("")){
					prop.setProperty("DB_USER", dbUser);
				}
				System.out.println("Please enter the db password:(default:" + prop.getProperty("DB_PASS")+")" );
				String dbPass = sc.nextLine();
				if(!dbPass.equals("")){
					prop.setProperty("DB_PASS", dbPass);
				}
				System.out.println("Please enter the tns name:(default:" + prop.getProperty("TNSNAME")+")" );
				String tnsName = sc.nextLine();
				if(!tnsName.equals("")){
					prop.setProperty("TNSNAME", tnsName);
				}
				prop.store(new FileOutputStream("installer.properties"), null);
				Process pro = Runtime.getRuntime().exec(SysExcUtil.getCmd(new String[]{"ant","dbAutoIns"}));
				processPrint(pro.getInputStream(),pro.getErrorStream());
			}else if(scStr.equals("2")){
				System.out.println("Please enter the web home:(default:" + prop.getProperty("WEB_HOME")+")" );
				String webHome = sc.nextLine();
				if(!webHome.equals("")){
					prop.setProperty("WEB_HOME", webHome);
				}
				prop.store(new FileOutputStream("installer.properties"), null);
				Process pro = Runtime.getRuntime().exec(SysExcUtil.getCmd(new String[]{"ant","webAutoIns"}));
				processPrint(pro.getInputStream(),pro.getErrorStream());
			}else if(scStr.equals("q")){
				System.out.println("exit Install!");
				return ;
			}
			install();
		} catch (IOException e) {
			System.out.println("The installer.properties not exist!");
			e.printStackTrace();
		}
	}
	
	private void processPrint(InputStream is,InputStream errIs){
		Scanner sc = new Scanner(is);
		while(sc.hasNext()){
			System.out.println(sc.nextLine());
		}
	}
	
	class ExecPrint implements Runnable{
		InputStream is ;
		String printType;
		Updater ins ;
		
		public ExecPrint(InputStream is,String  printType,Updater ins){
			this.is = is;
			this.printType = printType;
			this.ins = ins;
		}
		
		public void run(){
			Scanner sc = new Scanner(is);
			String str = "";
			if(this.printType.equals("error")){
				while(!Thread.currentThread().isInterrupted()&&!appExitFlag && sc.hasNext()){
					System.out.println(sc.nextLine());
					str += sc.nextLine();
				}
				ins.setErrorFlag(true);
			}else{
				while(!Thread.currentThread().isInterrupted()&&!errorFlag && sc.hasNext()){
					System.out.println(sc.nextLine());
					str += sc.nextLine();
				}
				ins.setAppExitFlag(true);
			}
		}
	}

	class PromptInfo {

		void printWelcomeInfo() {
			if(args != null && args[0] != null ){
				System.out.println(args[0]);
			}else{
				System.out.println("Welcome to install HEC2.0");
			}
		}

		void printEnterInfo() {
			System.out.println("1.Update Database");
			System.out.println("2.Update HEC2.0");
			System.out.println("enter q to exit!");
		}
	}

	public static void main(String args[]) {
		LogUtil.clearLog();
		Updater inst = new Updater();
		inst.args = args;
		inst.install();
	}

	public void setErrorFlag(Boolean errorFlag) {
		this.errorFlag = errorFlag;
	}

	public void setAppExitFlag(Boolean appExitFlag) {
		this.appExitFlag = appExitFlag;
	}
}
