/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx;

import com.topologi.diffx.DiffXException;
import com.topologi.diffx.Main;
import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.event.impl.CommentEvent;
import com.topologi.diffx.format.SmartXMLFormatter;
import com.topologi.diffx.load.DOMRecorder;
import com.topologi.diffx.sequence.EventSequence;
import com.topologi.diffx.sequence.PrefixMapping;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.compare.EventSequenceComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Docx4jDriver {
    public static final boolean debug = false;

    public static void log(String message, boolean force) {
        if (force) {
            System.out.println(message);
        }
    }

    public static void log(String message) {
        Docx4jDriver.log(message, false);
    }

    public static void diff(Node xml1, Node xml2, Writer out) throws DiffXException, IOException {
        try {
            DiffXConfig diffxConfig = new DiffXConfig();
            diffxConfig.setIgnoreWhiteSpace(false);
            diffxConfig.setPreserveWhiteSpace(true);
            Docx4jDriver.log(xml1.getNodeName());
            Docx4jDriver.log("" + xml1.getChildNodes().getLength());
            Docx4jDriver.log(xml2.getNodeName());
            Docx4jDriver.log("" + xml2.getChildNodes().getLength());
            if (!xml1.getNodeName().equals(xml2.getNodeName()) || xml1.getChildNodes().getLength() <= 3 && xml2.getChildNodes().getLength() <= 3) {
                Docx4jDriver.log("Skipping top level LCS");
                Main.diff(xml1, xml2, out, diffxConfig);
                out.close();
                return;
            }
            DOMRecorder loader = new DOMRecorder();
            loader.setConfig(diffxConfig);
            Docx4jDriver.log("top level LCS - creating EventSequences...");
            ArrayList<EventSequence> leftES = new ArrayList<EventSequence>();
            for (int i = 0; i < xml1.getChildNodes().getLength(); ++i) {
                if (xml1.getChildNodes().item(i).getNodeType() == 3) continue;
                Element e = (Element)xml1.getChildNodes().item(i);
                e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
                leftES.add(loader.process(e));
            }
            EventSequenceComparator leftESC = new EventSequenceComparator(leftES);
            ArrayList<EventSequence> rightES = new ArrayList<EventSequence>();
            for (int i = 0; i < xml2.getChildNodes().getLength(); ++i) {
                if (xml2.getChildNodes().item(i).getNodeType() == 3) continue;
                Element e = (Element)xml2.getChildNodes().item(i);
                e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
                rightES.add(loader.process(e));
            }
            EventSequenceComparator rightESC = new EventSequenceComparator(rightES);
            Docx4jDriver.log("top level LCS - determining top level LCS...");
            RangeDifference[] rd = RangeDifferencer.findDifferences(leftESC, rightESC);
            SmartXMLFormatter formatter = new SmartXMLFormatter(out);
            formatter.setConfig(diffxConfig);
            String rootNodeName = xml1.getNodeName();
            Docx4jDriver.openResult(rootNodeName, out);
            if (rd.length == 0) {
                Docx4jDriver.log("top level LCS done; there are no differences!");
                Docx4jDriver.addComment("No differences", formatter);
                for (EventSequence es : leftES) {
                    es.format(formatter);
                }
                Docx4jDriver.closeResult(rootNodeName, out);
                return;
            }
            for (int i = 0; i < rd.length; ++i) {
                RangeDifference rdi = rd[i];
                Docx4jDriver.log(rdi.kindString() + " left " + rdi.leftStart() + "," + rdi.leftLength() + " right " + rdi.rightStart() + "," + rdi.rightLength());
            }
            Docx4jDriver.log("top level LCS done; now performing child actions ...");
            int leftIdx = 0;
            for (int i = 0; i < rd.length; ++i) {
                RangeDifference rdi = rd[i];
                if (rdi.leftStart() > leftIdx) {
                    for (int k = leftIdx; k < rdi.leftStart(); ++k) {
                        Docx4jDriver.addComment("Adding same", formatter);
                        formatter.declarePrefixMapping(leftESC.getItem(k).getPrefixMapping());
                        leftESC.getItem(k).format(formatter);
                        Docx4jDriver.addComment(".. Adding same done ", formatter);
                    }
                    leftIdx = rdi.leftStart();
                }
                EventSequence seq1 = new EventSequence();
                for (int k = rdi.leftStart(); k < rdi.leftEnd(); ++k) {
                    if (rdi.kind() == 2) {
                        seq1.addSequence(leftESC.getItem(k));
                        PrefixMapping existingPM = leftESC.getItem(k).getPrefixMapping();
                        seq1.getPrefixMapping().add(existingPM);
                        continue;
                    }
                    formatter.declarePrefixMapping(leftESC.getItem(k).getPrefixMapping());
                    Docx4jDriver.addComment("Adding same II", formatter);
                    leftESC.getItem(k).format(formatter);
                    Docx4jDriver.addComment(".. Adding same done", formatter);
                }
                EventSequence seq2 = new EventSequence();
                for (int k = rdi.rightStart(); k < rdi.rightEnd(); ++k) {
                    if (rdi.kind() != 2) continue;
                    seq2.addSequence(rightESC.getItem(k));
                    PrefixMapping existingPM = rightESC.getItem(k).getPrefixMapping();
                    seq2.getPrefixMapping().add(existingPM);
                }
                leftIdx = rdi.leftEnd();
                Docx4jDriver.addComment("Differencing", formatter);
                if (seq1.size() + seq2.size() < 5000) {
                    Main.diff(seq1, seq2, formatter, diffxConfig);
                } else {
                    for (int i1 = 0; i1 < seq1.size(); ++i1) {
                        formatter.delete(seq1.getEvent(i1));
                    }
                    for (int i2 = 0; i2 < seq2.size(); ++i2) {
                        formatter.insert(seq2.getEvent(i2));
                    }
                }
                Docx4jDriver.addComment(".. Differencing done", formatter);
            }
            Docx4jDriver.addComment("Adding tail", formatter);
            if (rd.length > 0) {
                for (int k = rd[rd.length - 1].leftEnd(); k < leftESC.getRangeCount(); ++k) {
                    leftESC.getItem(k).format(formatter);
                }
            }
            Docx4jDriver.closeResult(rootNodeName, out);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new DiffXException(e);
        }
    }

    public static void addComment(String message, SmartXMLFormatter formatter) throws IOException {
        CommentEvent ce = new CommentEvent(message);
        formatter.format(ce);
    }

    public static void openResult(String nodename, Writer out) throws IOException {
        out.append("<" + nodename + " xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"" + " xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\"" + " xmlns:pic=\"http://schemas.openxmlformats.org/drawingml/2006/picture\"" + " xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"" + " xmlns:v=\"urn:schemas-microsoft-com:vml\"" + " xmlns:w10=\"urn:schemas-microsoft-com:office:word\"" + " xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\"" + " xmlns:dfx=\"" + "http://www.topologi.org/2004/Diff-X" + "\"" + " xmlns:del=\"" + "http://www.topologi.org/2004/Diff-X/Delete" + "\"" + " xmlns:ins=\"" + "http://www.topologi.org/2004/Diff-X" + "\"" + " >");
    }

    public static void closeResult(String nodename, Writer out) throws IOException {
        out.append("</" + nodename + ">");
    }

    public static void main(String[] args) throws Exception {
        StringWriter diffxResult = new StringWriter();
        try {
            long startTime = System.currentTimeMillis();
            Docx4jDriver.diff(Docx4jDriver.getDocument(new File("1L.xml")).getDocumentElement(), Docx4jDriver.getDocument(new File("1R.xml")).getDocumentElement(), diffxResult);
            ((Writer)diffxResult).close();
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            System.out.println(duration + "ms");
            System.out.println(((Object)diffxResult).toString());
        }
        catch (Exception exc) {
            exc.printStackTrace();
            diffxResult = null;
        }
    }

    private static Document getDocument(File f) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(f);
    }
}

