/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.load.text;

import com.topologi.diffx.event.TextEvent;
import com.topologi.diffx.event.impl.IgnorableSpaceEvent;
import com.topologi.diffx.event.impl.WordEvent;
import com.topologi.diffx.event.lang.Repertory;
import com.topologi.diffx.load.text.TextTokeniser;
import java.util.NoSuchElementException;

public final class TextTokeniserIgnoreSpace
implements TextTokeniser {
    private static final byte TEXT = 0;
    private static final byte SPACE = 1;
    private final CharSequence seq;
    private transient int max = -1;
    private transient int marker = 0;
    private transient Repertory repertory = null;

    public TextTokeniserIgnoreSpace(CharSequence cs) throws NullPointerException {
        if (cs == null) {
            throw new NullPointerException("The string buffer cannot be null.");
        }
        this.seq = cs;
    }

    public int countTokens() {
        if (this.seq.length() == 0) {
            return 0;
        }
        if (this.max >= 0) {
            return this.max;
        }
        byte type = -1;
        int counter = 0;
        for (int i = 0; i < this.seq.length(); ++i) {
            if (type == TextTokeniserIgnoreSpace.getType(this.seq.charAt(i))) continue;
            type = TextTokeniserIgnoreSpace.getType(this.seq.charAt(i));
            ++counter;
        }
        this.max = counter;
        return counter;
    }

    public TextEvent nextToken() throws NoSuchElementException {
        if (this.marker == this.seq.length()) {
            throw new NoSuchElementException("All tokens have been returned.");
        }
        byte type = TextTokeniserIgnoreSpace.getType(this.seq.charAt(this.marker));
        for (int i = this.marker; i < this.seq.length(); ++i) {
            if (type == TextTokeniserIgnoreSpace.getType(this.seq.charAt(i))) continue;
            TextEvent e = this.newToken(type, this.marker, i);
            this.marker = i;
            return e;
        }
        TextEvent e = this.newToken(type, this.marker, this.seq.length());
        this.marker = this.seq.length();
        return e;
    }

    public void useRepertory(Repertory rep) {
        this.repertory = rep;
    }

    private static byte getType(char c) {
        return Character.isWhitespace(c) ? (byte)1 : 0;
    }

    private TextEvent newToken(byte type, int start, int end) {
        switch (type) {
            case 0: {
                String word = ((Object)this.seq.subSequence(start, end)).toString();
                if (this.repertory == null) {
                    return new WordEvent(word);
                }
                return this.repertory.update(word);
            }
            case 1: {
                return new IgnorableSpaceEvent(this.seq.subSequence(start, end));
            }
        }
        throw new NoSuchElementException("Cannot create token of unknown type.");
    }
}

