/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml;

import com.topologi.diffx.Docx4jDriver;
import com.topologi.diffx.xml.UndeclaredNamespaceException;
import com.topologi.diffx.xml.XMLWriter;
import com.topologi.diffx.xml.XMLWriterBase;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public final class NSAwareXMLWriter
extends XMLWriterBase
implements XMLWriter {
    private static final boolean DEBUG = false;
    private static final PrefixMapping DEFAULT_NS = new PrefixMapping("", "");
    private static final Element ROOT;
    private Hashtable prefixMapping = new Hashtable();
    private List tempMapping = null;
    private List elements = new ArrayList();
    private boolean isNude = false;

    public NSAwareXMLWriter(Writer writer) throws NullPointerException {
        super(writer, true);
        this.elements.add(ROOT);
        this.prefixMapping.put("", "");
    }

    public NSAwareXMLWriter(Writer writer, boolean indent) throws NullPointerException {
        super(writer, indent);
        this.elements.add(ROOT);
        this.prefixMapping.put("", "");
    }

    public void writeComment(String comment) throws IOException {
        this.deNude();
        super.writeComment(comment);
    }

    public void writePI(String target, String data) throws IOException {
        this.deNude();
        super.writePI(target, data);
    }

    public void writeText(char c) throws IOException {
        this.deNude();
        this.writerEscape.writeText(c);
    }

    public void writeText(String text) throws IOException {
        if (text == null) {
            return;
        }
        this.deNude();
        this.writerEscape.writeText(text);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.deNude();
        this.writerEscape.writeText(text, off, len);
    }

    public void writeXML(String text) throws IOException {
        if (text == null) {
            return;
        }
        this.deNude();
        this.writer.write(text);
    }

    public void writeXML(char[] text, int off, int len) throws IOException {
        this.deNude();
        this.writer.write(text, off, len);
    }

    private void deNude() throws IOException {
        if (this.isNude) {
            this.writer.write(62);
            if (this.peekElement().hasChildren) {
                this.writer.write(10);
            }
            this.isNude = false;
        }
    }

    public void openElement(String name) throws IOException {
        this.openElement(null, name, false);
    }

    public void openElement(String uri, String name) throws IOException {
        this.openElement(uri, name, false);
    }

    public void openElement(String name, boolean hasChildren) throws IOException {
        this.openElement(null, name, hasChildren);
    }

    public void openElement(String uri, String name, boolean hasChildren) throws IOException {
        this.deNude();
        this.indent();
        String qName = this.getQName(uri, name);
        this.elements.add(new Element(qName, hasChildren, this.tempMapping));
        this.writer.write(60);
        this.writer.write(qName);
        this.handleNamespaceDeclaration();
        this.isNude = true;
        ++this.depth;
    }

    public void closeElement() throws IOException {
        if (this.elements.size() <= 1) {
            return;
        }
        Element elt = this.popElement();
        --this.depth;
        if (this.isNude) {
            this.writer.write(47);
            this.isNude = false;
        } else {
            if (elt.hasChildren) {
                this.indent();
            }
            this.writer.write(60);
            this.writer.write(47);
            int x = elt.qName.indexOf(32);
            if (x < 0) {
                this.writer.write(elt.qName);
            } else {
                this.writer.write(elt.qName.substring(0, x));
            }
        }
        this.restorePrefixMapping(elt);
        this.writer.write(62);
        if (this.indent) {
            this.writer.write(10);
        }
    }

    public void emptyElement(String element) throws IOException {
        this.emptyElement(null, element);
    }

    public void emptyElement(String uri, String element) throws IOException {
        this.deNude();
        this.indent();
        this.writer.write(60);
        this.writer.write(this.getQName(uri, element));
        this.handleNamespaceDeclaration();
        this.writer.write(47);
        this.writer.write(62);
        if (this.indent) {
            this.writer.write(10);
        }
    }

    private Element peekElement() {
        return (Element)this.elements.get(this.elements.size() - 1);
    }

    private Element popElement() {
        return (Element)this.elements.remove(this.elements.size() - 1);
    }

    public void attribute(String name, String value) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(name);
        this.writer.write("=\"");
        this.writerEscape.writeAttValue(value);
        this.writer.write(34);
    }

    public void attribute(String name, int value) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(name);
        this.writer.write("=\"");
        this.writer.write(Integer.toString(value));
        this.writer.write(34);
    }

    public void attribute(String uri, String name, String value) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(this.getQName(uri, name));
        this.writer.write("=\"");
        this.writerEscape.writeAttValue(value);
        this.writer.write(34);
        this.handleNamespaceDeclaration();
    }

    public void attribute(String uri, String name, int value) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(this.getQName(uri, name));
        this.writer.write("=\"");
        this.writer.write(Integer.toString(value));
        this.writer.write(34);
        this.handleNamespaceDeclaration();
    }

    public void setPrefixMapping(String uri, String prefix) throws NullPointerException {
        if (!prefix.equals(this.prefixMapping.get(uri))) {
            this.removeIfNeeded(prefix);
            PrefixMapping pm = new PrefixMapping(prefix, uri);
            this.prefixMapping.put(pm.uri, pm.prefix);
            if (this.tempMapping == null) {
                this.tempMapping = new ArrayList();
            }
            this.tempMapping.add(pm);
        }
    }

    private String getQName(String uri, String name) throws UndeclaredNamespaceException {
        String prefix = (String)this.prefixMapping.get(uri != null ? uri : "");
        if (prefix == null) {
            if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
                return "xml:" + name;
            }
            Docx4jDriver.log("FIX ME - com.topologi.diffx.xml.NSAwareXMLWriter.getQName(null, " + name + ") @599)");
            throw new UndeclaredNamespaceException(uri + " for " + name);
        }
        if ("".equals(prefix)) {
            return name;
        }
        try {
            return this.prefixMapping.get(uri) + ":" + name;
        }
        catch (RuntimeException e) {
            System.out.println("uri: " + uri + ", name: " + name);
            e.printStackTrace();
            return name;
        }
    }

    private void handleNamespaceDeclaration() throws IOException {
        if (this.tempMapping != null) {
            PrefixMapping pm = null;
            for (int i = 0; i < this.tempMapping.size(); ++i) {
                pm = (PrefixMapping)this.tempMapping.get(i);
                this.writer.write(" xmlns");
                if (!"".equals(pm.prefix)) {
                    this.writer.write(58);
                    this.writer.write(pm.prefix);
                }
                this.writer.write("=\"");
                this.writer.write(pm.uri);
                this.writer.write("\"");
            }
            this.tempMapping = null;
        }
    }

    private void restorePrefixMapping(Element elt) {
        if (elt.mappings != null) {
            for (int i = 0; i < elt.mappings.size(); ++i) {
                PrefixMapping mpi = (PrefixMapping)elt.mappings.get(i);
                block1: for (int j = this.elements.size() - 1; j > 0; --j) {
                    if (((Element)this.elements.get(j)).mappings == null) continue;
                    List mps = ((Element)this.elements.get(j)).mappings;
                    for (int k = 0; k < mps.size(); ++k) {
                        PrefixMapping mpk = (PrefixMapping)mps.get(k);
                        if (!mpk.prefix.equals(mpi.prefix)) continue;
                        this.removeIfNeeded(mpk.prefix);
                        this.prefixMapping.put(mpk.uri, mpk.prefix);
                        j = 0;
                        continue block1;
                    }
                }
            }
        }
    }

    private void removeIfNeeded(String prefix) {
        if (this.prefixMapping.containsValue(prefix)) {
            Object key = null;
            Enumeration e = this.prefixMapping.keys();
            while (e.hasMoreElements() && !this.prefixMapping.get(key = e.nextElement()).equals(prefix)) {
            }
            this.prefixMapping.remove(key);
        }
    }

    static {
        ArrayList<PrefixMapping> mps = new ArrayList<PrefixMapping>();
        mps.add(DEFAULT_NS);
        ROOT = new Element("", true, mps);
    }

    private static final class PrefixMapping {
        private final String prefix;
        private final String uri;

        public PrefixMapping(String prefix, String uri) {
            this.prefix = prefix != null ? prefix : "";
            this.uri = uri != null ? uri : "";
        }
    }

    private static final class Element {
        private String qName;
        private boolean hasChildren;
        private final List mappings;

        public Element(String qName, boolean hasChildren, List mappings) {
            this.qName = qName;
            this.hasChildren = hasChildren;
            this.mappings = mappings;
        }
    }
}

