/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml;

import com.topologi.diffx.xml.XMLWriter;
import com.topologi.diffx.xml.XMLWriterBase;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class SimpleXMLWriter
extends XMLWriterBase
implements XMLWriter {
    private static final Element ROOT = new Element("", true);
    private List elements = new ArrayList();
    private boolean isNude = false;

    public SimpleXMLWriter(Writer writer) throws NullPointerException {
        super(writer, true);
        this.elements.add(ROOT);
    }

    public SimpleXMLWriter(Writer writer, boolean indent) throws NullPointerException {
        super(writer, indent);
        this.elements.add(ROOT);
    }

    public void writeComment(String comment) throws IOException {
        this.deNude();
        super.writeComment(comment);
    }

    public void writePI(String target, String data) throws IOException {
        this.deNude();
        super.writePI(target, data);
    }

    public void writeText(char c) throws IOException {
        this.deNude();
        this.writerEscape.writeText(c);
    }

    public void writeText(String text) throws IOException {
        if (text == null) {
            return;
        }
        this.deNude();
        this.writerEscape.writeText(text);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.deNude();
        this.writerEscape.writeText(text, off, len);
    }

    public void writeXML(String text) throws IOException {
        if (text == null) {
            return;
        }
        this.deNude();
        this.writer.write(text);
    }

    public void writeXML(char[] text, int off, int len) throws IOException {
        this.deNude();
        this.writer.write(text, off, len);
    }

    private void deNude() throws IOException {
        if (this.isNude) {
            this.writer.write(62);
            if (this.peekElement().hasChildren) {
                this.writer.write(10);
            }
            this.isNude = false;
        }
    }

    public void openElement(String name) throws IOException {
        this.openElement(name, false);
    }

    public void openElement(String name, boolean hasChildren) throws IOException {
        this.deNude();
        this.indent();
        this.elements.add(new Element(name, hasChildren));
        this.writer.write(60);
        this.writer.write(name);
        this.isNude = true;
        ++this.depth;
    }

    public void closeElement() throws IOException {
        Element elt = this.popElement();
        --this.depth;
        if (this.isNude) {
            this.writer.write(47);
            this.isNude = false;
        } else {
            if (elt.hasChildren) {
                this.indent();
            }
            this.writer.write(60);
            this.writer.write(47);
            int x = elt.name.indexOf(32);
            if (x < 0) {
                this.writer.write(elt.name);
            } else {
                this.writer.write(elt.name.substring(0, x));
            }
        }
        this.writer.write(62);
    }

    public void emptyElement(String element) throws IOException {
        this.deNude();
        this.indent();
        this.writer.write(60);
        this.writer.write(element);
        this.writer.write(47);
        this.writer.write(62);
        this.writer.write(10);
    }

    private Element peekElement() {
        return (Element)this.elements.get(this.elements.size() - 1);
    }

    private Element popElement() {
        return (Element)this.elements.remove(this.elements.size() - 1);
    }

    public void attribute(String name, String value) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(name);
        this.writer.write("=\"");
        this.writerEscape.writeAttValue(value);
        this.writer.write(34);
    }

    public void attribute(String name, int value) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(name);
        this.writer.write("=\"");
        this.writer.write(Integer.toString(value));
        this.writer.write(34);
    }

    public void openElement(String uri, String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces.");
    }

    public void openElement(String uri, String name, boolean hasChildren) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces.");
    }

    public void emptyElement(String uri, String element) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    public void setPrefixMapping(String uri, String prefix) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    public void attribute(String uri, String name, String value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    public void attribute(String uri, String name, int value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    private static final class Element {
        private String name;
        private boolean hasChildren;

        public Element(String name, boolean hasChildren) {
            this.name = name;
            this.hasChildren = hasChildren;
        }
    }
}

