/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.log4j.Logger;

public class UnitsOfMeasurement {
    private static final Logger log = Logger.getLogger(UnitsOfMeasurement.class);
    public static final DecimalFormat format2DP = new DecimalFormat("##.##", new DecimalFormatSymbols(Locale.ENGLISH));

    public static long twipToEMU(double twips) {
        return Math.round(635.0 * twips);
    }

    public static int inchToTwip(float inch) {
        return Math.round(inch * 1440.0f);
    }

    public static float twipToInch(int twip) {
        return (float)twip / 1440.0f;
    }

    public static int mmToTwip(float mm) {
        float inch = mm * 0.0394f;
        return UnitsOfMeasurement.inchToTwip(inch);
    }

    public static String twipToBest(int leftL) {
        float inch4f = 80.0f * UnitsOfMeasurement.twipToInch(leftL);
        float inch4fabit = inch4f + 0.49f;
        int inch4 = Math.round(inch4f);
        int inch4next = Math.round(inch4fabit);
        float inches = UnitsOfMeasurement.twipToInch(leftL);
        if (inch4 == inch4next) {
            log.debug((Object)(leftL + " twips -> " + inches + "inches"));
            return format2DP.format(inches) + "in";
        }
        float mm = inches / 0.0394f;
        log.debug((Object)(leftL + " twips -> " + mm + "mm (" + format2DP.format(inches) + "inches)"));
        return Math.round(mm) + "mm";
    }

    public static String rgbTripleToHex(float red, float green, float blue) {
        return UnitsOfMeasurement.getHex(red) + UnitsOfMeasurement.getHex(green) + UnitsOfMeasurement.getHex(blue);
    }

    private static String getHex(float f) {
        int i = Math.round(f);
        if (i <= 16) {
            return "0" + Integer.toHexString(i);
        }
        return Integer.toHexString(i);
    }
}

