/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import java.io.File;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.html.AbstractHtmlExporter;
import org.docx4j.convert.out.html.HTMLConversionImageHandler;
import org.docx4j.convert.out.html.TableWriter;
import org.docx4j.dml.CTBlip;
import org.docx4j.dml.wordprocessingDrawing.Anchor;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.model.images.ConversionImageHandler;
import org.docx4j.model.images.WordXmlPictureE10;
import org.docx4j.model.images.WordXmlPictureE20;
import org.docx4j.model.listnumbering.Emulator;
import org.docx4j.model.styles.Node;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.model.styles.Tree;
import org.docx4j.model.table.TableModel;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.Pict;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class HtmlExporterNonXSLT {
    private static Logger log = Logger.getLogger(HtmlExporterNonXSLT.class);
    public static JAXBContext context = Context.jc;
    protected static String inputfilepath;
    protected static String outputfilepath;
    Document htmlDoc;
    Element headEl;
    Element bodyEl;
    WordprocessingMLPackage wordMLPackage;
    StyleTree styleTree;
    ConversionImageHandler conversionImageHandler;
    TableModel.TableModelTransformState tableModelTransformState = new TableModel.TableModelTransformState();

    public HtmlExporterNonXSLT(WordprocessingMLPackage wordMLPackage, ConversionImageHandler conversionImageHandler) {
        this.wordMLPackage = wordMLPackage;
        this.conversionImageHandler = conversionImageHandler;
        this.styleTree = null;
        try {
            this.styleTree = wordMLPackage.getMainDocumentPart().getStyleTree();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Document export() {
        this.htmlDoc = XmlUtils.neww3cDomDocument();
        Element htmlEl = this.htmlDoc.createElement("html");
        this.htmlDoc.appendChild(htmlEl);
        this.headEl = this.htmlDoc.createElement("head");
        htmlEl.appendChild(this.headEl);
        this.bodyEl = this.htmlDoc.createElement("body");
        htmlEl.appendChild(this.bodyEl);
        Element styleEl = this.htmlDoc.createElement("style");
        this.headEl.appendChild(styleEl);
        styleEl.appendChild(this.htmlDoc.createComment(AbstractHtmlExporter.getCssForStyles(this.wordMLPackage)));
        List<Object> blockLevelContent = this.wordMLPackage.getMainDocumentPart().getContent();
        HTMLGenerator htmlGenerator = new HTMLGenerator();
        new TraversalUtil(blockLevelContent, htmlGenerator);
        return this.htmlDoc;
    }

    public String getCss() {
        return AbstractHtmlExporter.getCssForStyles(this.wordMLPackage);
    }

    public Document export(Object blockLevelContent, String cssClass, String cssId) {
        this.htmlDoc = XmlUtils.neww3cDomDocument();
        this.bodyEl = this.htmlDoc.createElement("div");
        if (cssClass != null) {
            this.bodyEl.setAttribute("class", cssClass);
        }
        if (cssId != null) {
            this.bodyEl.setAttribute("id", cssId);
        }
        this.htmlDoc.appendChild(this.bodyEl);
        HTMLGenerator htmlGenerator = new HTMLGenerator();
        new TraversalUtil(blockLevelContent, htmlGenerator);
        return this.htmlDoc;
    }

    void handlePPr(PPr pPr, Element currentEl) {
        if (pPr != null) {
            Emulator.ResultTriple triple;
            String pStyleVal = null;
            if (pPr.getPStyle() != null && pPr.getPStyle().getVal() != null) {
                pStyleVal = pPr.getPStyle().getVal();
                Tree<StyleTree.AugmentedStyle> pTree = this.styleTree.getParagraphStylesTree();
                Node<StyleTree.AugmentedStyle> asn = pTree.get(pStyleVal);
                currentEl.setAttribute("class", StyleTree.getHtmlClassAttributeValue(pTree, asn));
            }
            boolean ignoreBorders = true;
            StringBuffer inlineStyle = new StringBuffer();
            AbstractHtmlExporter.createCss(this.wordMLPackage, pPr, inlineStyle, ignoreBorders);
            if (!inlineStyle.toString().equals("")) {
                currentEl.setAttribute("style", inlineStyle.toString());
            }
            String numberText = null;
            String numId = null;
            String levelId = null;
            if (pPr.getNumPr() != null) {
                numId = pPr.getNumPr().getNumId() == null ? null : pPr.getNumPr().getNumId().getVal().toString();
                String string = levelId = pPr.getNumPr().getIlvl() == null ? null : pPr.getNumPr().getIlvl().getVal().toString();
            }
            if ((triple = Emulator.getNumber(this.wordMLPackage, pStyleVal, numId, levelId)) == null) {
                log.debug((Object)"computed number ResultTriple was null");
            } else if (triple.getBullet() != null) {
                numberText = "\u2022  ";
            } else if (triple.getNumString() == null) {
                log.error((Object)"computed NumString was null!");
                numberText = "?";
            } else {
                numberText = triple.getNumString() + " ";
            }
            if (numberText != null) {
                currentEl.appendChild(this.htmlDoc.createTextNode(numberText + " "));
            }
        }
    }

    void handleRPr(RPr rPr, Element spanEl) {
        if (rPr.getRStyle() != null) {
            String rStyleVal = rPr.getRStyle().getVal();
            Tree<StyleTree.AugmentedStyle> cTree = this.styleTree.getCharacterStylesTree();
            Node<StyleTree.AugmentedStyle> asn = cTree.get(rStyleVal);
            if (asn == null) {
                log.warn((Object)("No style node for: " + rStyleVal));
            } else {
                spanEl.setAttribute("class", StyleTree.getHtmlClassAttributeValue(cTree, asn));
            }
        }
        StringBuffer inlineStyle = new StringBuffer();
        AbstractHtmlExporter.createCss(this.wordMLPackage, rPr, inlineStyle);
        if (!inlineStyle.toString().equals("")) {
            spanEl.setAttribute("style", inlineStyle.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        inputfilepath = System.getProperty("user.dir") + "/hr.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        HtmlExporterNonXSLT withoutXSLT = new HtmlExporterNonXSLT(wordMLPackage, new HTMLConversionImageHandler("c:\\temp", "/bar", true));
        log.info((Object)XmlUtils.w3CDomNodeToString(withoutXSLT.export()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TableRowTraversor
    extends TraversalUtil.CallbackImpl {
        Element currentP;
        Element currentSpan;
        DocumentFragment tableFragment;
        Element tr;
        Element tc;

        TableRowTraversor() {
            this.tableFragment = HtmlExporterNonXSLT.this.htmlDoc.createDocumentFragment();
        }

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof P) {
                this.currentP = HtmlExporterNonXSLT.this.htmlDoc.createElement("p");
                this.currentSpan = null;
                this.tc.appendChild(this.currentP);
                PPr pPr = ((P)o).getPPr();
                HtmlExporterNonXSLT.this.handlePPr(pPr, this.currentP);
            } else if (o instanceof R) {
                RPr rPr = ((R)o).getRPr();
                if (rPr != null) {
                    Element spanEl = HtmlExporterNonXSLT.this.htmlDoc.createElement("span");
                    this.currentP.appendChild(spanEl);
                    this.currentSpan = spanEl;
                    HtmlExporterNonXSLT.this.handleRPr(rPr, this.currentSpan);
                }
            } else if (o instanceof Text) {
                if (this.currentSpan != null) {
                    this.currentSpan.appendChild(HtmlExporterNonXSLT.this.htmlDoc.createTextNode(((Text)o).getValue()));
                } else {
                    this.currentP.appendChild(HtmlExporterNonXSLT.this.htmlDoc.createTextNode(((Text)o).getValue()));
                }
            } else if (!(o instanceof Tbl)) {
                if (o instanceof Tr) {
                    this.tr = HtmlExporterNonXSLT.this.htmlDoc.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tr");
                    this.tableFragment.appendChild(this.tr);
                } else if (o instanceof Tc) {
                    this.tc = HtmlExporterNonXSLT.this.htmlDoc.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tc");
                    this.tr.appendChild(this.tc);
                } else {
                    log.info((Object)("Encountered " + o.getClass().getName()));
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HTMLGenerator
    extends TraversalUtil.CallbackImpl {
        Element currentP;
        Element currentSpan;
        Object anchorOrInline;

        HTMLGenerator() {
        }

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof P) {
                this.currentP = HtmlExporterNonXSLT.this.htmlDoc.createElement("p");
                this.currentSpan = null;
                HtmlExporterNonXSLT.this.bodyEl.appendChild(this.currentP);
                PPr pPr = ((P)o).getPPr();
                HtmlExporterNonXSLT.this.handlePPr(pPr, this.currentP);
            } else if (o instanceof R) {
                RPr rPr = ((R)o).getRPr();
                if (rPr != null) {
                    Element spanEl = HtmlExporterNonXSLT.this.htmlDoc.createElement("span");
                    this.currentP.appendChild(spanEl);
                    this.currentSpan = spanEl;
                    HtmlExporterNonXSLT.this.handleRPr(rPr, this.currentSpan);
                }
            } else if (o instanceof Text) {
                if (this.currentSpan != null) {
                    this.currentSpan.appendChild(HtmlExporterNonXSLT.this.htmlDoc.createTextNode(((Text)o).getValue()));
                } else {
                    this.currentP.appendChild(HtmlExporterNonXSLT.this.htmlDoc.createTextNode(((Text)o).getValue()));
                }
            } else if (o instanceof Tbl) {
                Tbl tbl = (Tbl)o;
                TableRowTraversor tableRowTraversor = new TableRowTraversor();
                new TraversalUtil(tbl.getContent(), tableRowTraversor);
                try {
                    TableModel tm = new TableModel();
                    tm.setWordMLPackage(HtmlExporterNonXSLT.this.wordMLPackage);
                    tm.build(tbl, tableRowTraversor.tableFragment);
                    TableWriter tableWriter = new TableWriter();
                    tableWriter.setWordMLPackage(HtmlExporterNonXSLT.this.wordMLPackage);
                    org.w3c.dom.Node htmlTable = tableWriter.toNode(tm, HtmlExporterNonXSLT.this.tableModelTransformState, HtmlExporterNonXSLT.this.htmlDoc);
                    this.currentP.appendChild(htmlTable);
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
            } else if (o instanceof Inline || o instanceof Anchor) {
                this.anchorOrInline = o;
            } else if (o instanceof CTBlip) {
                DocumentFragment foreignFragment = WordXmlPictureE20.createHtmlImgE20(HtmlExporterNonXSLT.this.wordMLPackage, HtmlExporterNonXSLT.this.conversionImageHandler, this.anchorOrInline);
                this.anchorOrInline = null;
                this.currentP.appendChild(HtmlExporterNonXSLT.this.htmlDoc.importNode(foreignFragment, true));
            } else if (o instanceof Pict) {
                DocumentFragment foreignFragment = WordXmlPictureE10.createHtmlImgE10(HtmlExporterNonXSLT.this.wordMLPackage, HtmlExporterNonXSLT.this.conversionImageHandler, o);
                this.currentP.appendChild(HtmlExporterNonXSLT.this.htmlDoc.importNode(foreignFragment, true));
            } else {
                log.info((Object)("Encountered " + o.getClass().getName()));
            }
            return null;
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return !(o instanceof Tbl);
        }
    }
}

