/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.ModelConverter;
import org.docx4j.convert.out.html.AbstractHtmlExporter;
import org.docx4j.model.Model;
import org.docx4j.model.TransformState;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.styles.Node;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.model.styles.Tree;
import org.docx4j.model.table.Cell;
import org.docx4j.model.table.TableModel;
import org.docx4j.wml.TblGridCol;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class TableWriter
extends ModelConverter {
    private static final Logger log = Logger.getLogger(TableWriter.class);
    public static final String TABLE_LAYOUT_MODE = "table-layout";
    public static final String TABLE_BORDER_MODEL = "border-collapse";
    public static final String TABLE_INDENT = "margin-left";

    public static String getId(int idx) {
        return "docx4j_tbl_" + idx;
    }

    public org.w3c.dom.Node toNode(Model tableModel, TransformState transformState) throws TransformerException {
        Document doc = XmlUtils.neww3cDomDocument();
        return this.toNode(tableModel, transformState, doc);
    }

    public org.w3c.dom.Node toNode(Model tableModel, TransformState transformState, Document doc) throws TransformerException {
        TableModel table = (TableModel)tableModel;
        TableModel.TableModelTransformState state = (TableModel.TableModelTransformState)transformState;
        log.debug((Object)("Table asXML:\n" + table.debugStr()));
        Element tbl = doc.createElement("table");
        DocumentFragment docfrag = doc.createDocumentFragment();
        docfrag.appendChild(tbl);
        if (table.getStyleId() == null) {
            log.debug((Object)"table has no w:tblStyle?");
        } else {
            StyleTree styleTree = this.wordMLPackage.getMainDocumentPart().getStyleTree();
            Tree<StyleTree.AugmentedStyle> tTree = styleTree.getTableStylesTree();
            Node<StyleTree.AugmentedStyle> asn = tTree.get(table.getStyleId());
            tbl.setAttribute("class", StyleTree.getHtmlClassAttributeValue(tTree, asn));
        }
        tbl.setAttribute("id", TableWriter.getId(state.getIdx()));
        StringBuffer styleVal = new StringBuffer();
        List<Property> properties = PropertyFactory.createProperties(table.getTblPr());
        for (Property p : properties) {
            styleVal.append(p.getCssProperty());
        }
        if (table.getTblPr().getTblBorders() != null) {
            properties = PropertyFactory.createProperties(table.getTblPr());
            for (Property p : properties) {
                if (p == null) continue;
                styleVal.append(p.getCssProperty());
            }
        }
        if (table.isBorderConflictResolutionRequired()) {
            styleVal.append(Property.composeCss(TABLE_BORDER_MODEL, "collapse"));
        } else {
            styleVal.append(Property.composeCss(TABLE_BORDER_MODEL, "separate"));
        }
        tbl.setAttribute("style", styleVal.toString());
        int cols = table.getColCount();
        Element colgroup = doc.createElement("colgroup");
        tbl.appendChild(colgroup);
        if (table.getTblGrid() != null) {
            for (TblGridCol gridCol : table.getTblGrid().getGridCol()) {
                Element col = doc.createElement("col");
                int width = gridCol.getW().intValue();
                col.setAttribute("style", Property.composeCss("width", UnitsOfMeasurement.twipToBest(width)));
                colgroup.appendChild(col);
            }
        } else {
            log.warn((Object)"No w:tblGrid");
            colgroup.setAttribute("span", String.valueOf(cols));
        }
        Element tbody = doc.createElement("tbody");
        tbl.appendChild(tbody);
        for (List<Cell> rows : table.getCells()) {
            Element row = doc.createElement("tr");
            tbody.appendChild(row);
            if (table.getEffectiveTableStyle().getTcPr() == null || table.getEffectiveTableStyle().getTcPr().getVAlign() == null) {
                row.setAttribute("style", Property.composeCss("vertical-align", "top"));
            }
            for (Cell cell : rows) {
                if (cell.isDummy()) continue;
                int col = cell.getColumn();
                Element cellNode = doc.createElement("td");
                row.appendChild(cellNode);
                if (cell.getTcPr() != null) {
                    StringBuffer inlineStyle = new StringBuffer();
                    AbstractHtmlExporter.createCss(cell.getTcPr(), inlineStyle);
                    if (!inlineStyle.toString().equals("")) {
                        cellNode.setAttribute("style", inlineStyle.toString());
                    }
                }
                if (cell.getExtraCols() > 0) {
                    cellNode.setAttribute("colspan", Integer.toString(cell.getExtraCols() + 1));
                }
                if (cell.getExtraRows() > 0) {
                    cellNode.setAttribute("rowspan", Integer.toString(cell.getExtraRows() + 1));
                }
                if (cell.getContent() == null) {
                    log.warn((Object)"model cell had no contents!");
                    continue;
                }
                log.debug((Object)"copying cell contents..");
                XmlUtils.treeCopy(cell.getContent().getChildNodes(), (org.w3c.dom.Node)cellNode);
            }
        }
        state.incrementIdx();
        return docfrag;
    }
}

