/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.docx4j.fonts.fop.apps.FOPException;
import org.docx4j.fonts.fop.fonts.FontManager;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.fonts.fop.fonts.substitute.FontSubstitutions;
import org.docx4j.fonts.fop.fonts.substitute.FontSubstitutionsConfigurator;
import org.docx4j.fonts.fop.util.LogUtil;

public class FontManagerConfigurator {
    private static Log log = LogFactory.getLog(FontManagerConfigurator.class);
    private Configuration cfg;

    public FontManagerConfigurator(Configuration cfg) {
        this.cfg = cfg;
    }

    public void configure(FontManager fontManager, boolean strict) throws FOPException {
        Configuration fontsCfg;
        if (this.cfg.getChild("use-cache", false) != null) {
            try {
                fontManager.setUseCache(this.cfg.getChild("use-cache").getValueAsBoolean());
            }
            catch (ConfigurationException mfue) {
                LogUtil.handleException(log, (Exception)((Object)mfue), true);
            }
        }
        if (this.cfg.getChild("font-base", false) != null) {
            try {
                fontManager.setFontBaseURL(this.cfg.getChild("font-base").getValue(null));
            }
            catch (MalformedURLException mfue) {
                LogUtil.handleException(log, mfue, true);
            }
        }
        if ((fontsCfg = this.cfg.getChild("fonts", false)) != null) {
            Configuration referencedFontsCfg;
            Configuration substitutionsCfg = fontsCfg.getChild("substitutions", false);
            if (substitutionsCfg != null) {
                FontSubstitutionsConfigurator fontSubstitutionsConfigurator = new FontSubstitutionsConfigurator(substitutionsCfg);
                FontSubstitutions substitutions = new FontSubstitutions();
                fontSubstitutionsConfigurator.configure(substitutions);
                fontManager.setFontSubstitutions(substitutions);
            }
            if ((referencedFontsCfg = fontsCfg.getChild("referenced-fonts", false)) != null) {
                FontManagerConfigurator.createReferencedFontsMatcher(referencedFontsCfg, strict, fontManager);
            }
        }
    }

    private static void createReferencedFontsMatcher(Configuration referencedFontsCfg, boolean strict, FontManager fontManager) throws FOPException {
        ArrayList<FontFamilyRegExFontTripletMatcher> matcherList = new ArrayList<FontFamilyRegExFontTripletMatcher>();
        Configuration[] matches = referencedFontsCfg.getChildren("match");
        for (int i = 0; i < matches.length; ++i) {
            try {
                matcherList.add(new FontFamilyRegExFontTripletMatcher(matches[i].getAttribute("font-family")));
                continue;
            }
            catch (ConfigurationException ce) {
                LogUtil.handleException(log, (Exception)((Object)ce), strict);
            }
        }
        OrFontTripletMatcher orMatcher = new OrFontTripletMatcher(matcherList.toArray(new FontTriplet.Matcher[matcherList.size()]));
        fontManager.setReferencedFontsMatcher(orMatcher);
    }

    private static class FontFamilyRegExFontTripletMatcher
    implements FontTriplet.Matcher {
        private Pattern regex;

        public FontFamilyRegExFontTripletMatcher(String regex) {
            this.regex = Pattern.compile(regex);
        }

        public boolean matches(FontTriplet triplet) {
            return this.regex.matcher(triplet.getName()).matches();
        }
    }

    private static class OrFontTripletMatcher
    implements FontTriplet.Matcher {
        private FontTriplet.Matcher[] matchers;

        public OrFontTripletMatcher(FontTriplet.Matcher[] matchers) {
            this.matchers = matchers;
        }

        public boolean matches(FontTriplet triplet) {
            int c = this.matchers.length;
            for (int i = 0; i < c; ++i) {
                if (!this.matchers[i].matches(triplet)) continue;
                return true;
            }
            return false;
        }
    }
}

