/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts.substitute;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.docx4j.fonts.fop.fonts.FontInfo;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.fonts.fop.fonts.substitute.FontQualifier;
import org.docx4j.fonts.fop.fonts.substitute.FontSubstitution;

public class FontSubstitutions
extends ArrayList {
    private static final long serialVersionUID = -9173104935431899722L;
    protected static Log log = LogFactory.getLog(FontSubstitutions.class);

    public void adjustFontInfo(FontInfo fontInfo) {
        Iterator subsIt = super.iterator();
        while (subsIt.hasNext()) {
            FontSubstitution substitution = (FontSubstitution)subsIt.next();
            FontQualifier toQualifier = substitution.getToQualifier();
            FontTriplet fontTriplet = toQualifier.bestMatch(fontInfo);
            if (fontTriplet == null) {
                log.error((Object)("Unable to match font substitution for destination qualifier " + toQualifier));
                continue;
            }
            String internalFontKey = fontInfo.getInternalFontKey(fontTriplet);
            FontQualifier fromQualifier = substitution.getFromQualifier();
            List tripletList = fromQualifier.getTriplets();
            for (FontTriplet triplet : tripletList) {
                fontInfo.addFontProperties(internalFontKey, triplet);
            }
        }
    }
}

