/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.listnumbering;

import java.math.BigInteger;
import org.apache.log4j.Logger;
import org.docx4j.model.listnumbering.NumberFormatDecimalZero;
import org.docx4j.model.listnumbering.NumberFormatLowerLetter;
import org.docx4j.model.listnumbering.NumberFormatRomanLower;
import org.docx4j.model.listnumbering.NumberFormatRomanUpper;
import org.docx4j.wml.Lvl;
import org.docx4j.wml.NumFmt;
import org.docx4j.wml.NumberFormat;
import org.docx4j.wml.RFonts;

public class ListLevel {
    protected static Logger log = Logger.getLogger(ListLevel.class);
    private Lvl jaxbAbstractLvl;
    private Lvl jaxbOverrideLvl;
    private Counter counter;
    private boolean encounteredAlready = false;
    private String id;
    private BigInteger startValue = BigInteger.ZERO;
    private String levelText;
    private String font;
    private NumberFormat numFmt;
    private boolean isBullet;

    public Lvl getJaxbAbstractLvl() {
        return this.jaxbAbstractLvl;
    }

    public Lvl getJaxbOverrideLvl() {
        return this.jaxbOverrideLvl;
    }

    public ListLevel(Lvl levelNode) {
        NumFmt enumTypeNode;
        Lvl.LvlText levelTextNode;
        this.jaxbAbstractLvl = levelNode;
        this.id = levelNode.getIlvl().toString();
        this.counter = new Counter();
        Lvl.Start startValueNode = levelNode.getStart();
        if (startValueNode != null) {
            this.startValue = startValueNode.getVal().subtract(BigInteger.ONE);
            this.counter.setCurrentValue(this.startValue);
        }
        if ((levelTextNode = levelNode.getLvlText()) != null) {
            this.levelText = levelTextNode.getVal();
        }
        RFonts fontNode = null;
        if (levelNode.getRPr() != null) {
            fontNode = levelNode.getRPr().getRFonts();
        }
        if (fontNode != null) {
            this.font = fontNode.getHAnsi();
        }
        if ((enumTypeNode = levelNode.getNumFmt()) != null) {
            this.numFmt = enumTypeNode.getVal();
            this.isBullet = this.numFmt.equals((Object)NumberFormat.BULLET);
        }
    }

    public ListLevel(ListLevel masterCopy) {
        this.jaxbAbstractLvl = masterCopy.jaxbAbstractLvl;
        this.id = masterCopy.id;
        this.levelText = masterCopy.levelText;
        this.startValue = masterCopy.startValue;
        this.counter = masterCopy.counter;
        this.font = masterCopy.font;
        this.isBullet = masterCopy.isBullet;
        this.numFmt = masterCopy.numFmt;
    }

    public void SetOverrides(Lvl levelNode) {
        NumFmt enumTypeNode;
        Lvl.LvlText levelTextNode;
        this.jaxbOverrideLvl = levelNode;
        Lvl.Start startValueNode = levelNode.getStart();
        if (startValueNode != null) {
            this.startValue = startValueNode.getVal().subtract(BigInteger.ONE);
            this.counter.setCurrentValue(this.startValue);
        }
        if ((levelTextNode = levelNode.getLvlText()) != null) {
            this.levelText = levelTextNode.getVal();
        }
        RFonts fontNode = null;
        if (levelNode.getRPr() != null) {
            fontNode = levelNode.getRPr().getRFonts();
        }
        if (fontNode != null) {
            this.font = fontNode.getHAnsi();
        }
        if ((enumTypeNode = levelNode.getNumFmt()) != null) {
            this.numFmt = enumTypeNode.getVal();
            this.isBullet = this.numFmt.equals((Object)NumberFormat.BULLET);
        }
    }

    public String getID() {
        return this.id;
    }

    public void setStartValue(BigInteger startValue) {
        this.startValue = startValue;
    }

    public BigInteger getStartValue() {
        return this.startValue;
    }

    public String getCurrentValueFormatted() {
        if (this.numFmt.equals((Object)NumberFormat.DECIMAL)) {
            return this.counter.getCurrentValue().toString();
        }
        if (this.numFmt.equals((Object)NumberFormat.NONE)) {
            return "";
        }
        if (this.numFmt.equals((Object)NumberFormat.BULLET)) {
            return "*";
        }
        int current = this.counter.getCurrentValue().intValue();
        if (this.numFmt.equals((Object)NumberFormat.UPPER_ROMAN)) {
            NumberFormatRomanUpper converter = new NumberFormatRomanUpper();
            return converter.format(current);
        }
        if (this.numFmt.equals((Object)NumberFormat.LOWER_ROMAN)) {
            NumberFormatRomanLower converter = new NumberFormatRomanLower();
            return converter.format(current);
        }
        if (this.numFmt.equals((Object)NumberFormat.LOWER_LETTER)) {
            NumberFormatLowerLetter converter = new NumberFormatLowerLetter();
            return converter.format(current);
        }
        if (this.numFmt.equals((Object)NumberFormat.UPPER_LETTER)) {
            NumberFormatLowerLetter converter = new NumberFormatLowerLetter();
            return converter.format(current).toUpperCase();
        }
        if (this.numFmt.equals((Object)NumberFormat.DECIMAL_ZERO)) {
            NumberFormatDecimalZero converter = new NumberFormatDecimalZero();
            return converter.format(current);
        }
        log.error((Object)("Unhandled numFmt: " + this.numFmt.name()));
        return this.counter.getCurrentValue().toString();
    }

    public String getCurrentValueUnformatted() {
        return this.counter.getCurrentValue().toString();
    }

    public void IncrementCounter() {
        if (!this.encounteredAlready) {
            this.counter.setCurrentValue(this.startValue);
            this.encounteredAlready = true;
        }
        this.counter.IncrementCounter();
    }

    public void ResetCounter() {
        this.counter.setCurrentValue(this.startValue);
    }

    public String getLevelText() {
        return this.levelText;
    }

    public String getFont() {
        return this.font;
    }

    protected NumberFormat getNumFmt() {
        return this.numFmt;
    }

    public boolean IsBullet() {
        return this.isBullet;
    }

    protected class Counter {
        private BigInteger currentValue = BigInteger.ZERO;

        Counter() {
        }

        public void setCurrentValue(BigInteger currentValue) {
            this.currentValue = currentValue;
        }

        public BigInteger getCurrentValue() {
            log.debug((Object)("counter: " + this.currentValue.intValue()));
            return this.currentValue;
        }

        public void IncrementCounter() {
            this.setCurrentValue(this.currentValue.add(BigInteger.ONE));
            log.debug((Object)("counter now: " + this.currentValue.intValue()));
        }
    }
}

