/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.paragraph;

import java.math.BigInteger;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.paragraph.AbstractParagraphProperty;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class Indent
extends AbstractParagraphProperty {
    public static final String CSS_NAME = "margin-left";
    public static final String FO_NAME = "start-indent";
    public static final String FO_NAME_TEXT_INDENT = "text-indent";

    public String getCssName() {
        return CSS_NAME;
    }

    public Indent(PPrBase.Ind val) {
        this.setObject(val);
    }

    public Indent(CSSValue value) {
        int twip;
        this.debug(CSS_NAME, value);
        PPrBase.Ind ind = Context.getWmlObjectFactory().createPPrBaseInd();
        CSSPrimitiveValue cssPrimitiveValue = (CSSPrimitiveValue)value;
        short ignored = 1;
        float fVal = cssPrimitiveValue.getFloatValue(ignored);
        short type = cssPrimitiveValue.getPrimitiveType();
        if (8 == type) {
            twip = UnitsOfMeasurement.inchToTwip(fVal);
        } else if (7 == type) {
            twip = UnitsOfMeasurement.mmToTwip(fVal);
        } else {
            log.error((Object)("No support for unit " + type));
            twip = 0;
        }
        ind.setLeft(BigInteger.valueOf(twip));
        this.setObject(ind);
    }

    public String getCssProperty() {
        BigInteger hanging;
        BigInteger firstline;
        String prop = "position: relative; ";
        BigInteger left = ((PPrBase.Ind)this.getObject()).getLeft();
        if (left != null) {
            prop = prop + Indent.composeCss(CSS_NAME, UnitsOfMeasurement.twipToBest(left.intValue()));
        }
        if ((firstline = ((PPrBase.Ind)this.getObject()).getFirstLine()) != null) {
            prop = prop + Indent.composeCss(FO_NAME_TEXT_INDENT, UnitsOfMeasurement.twipToBest(firstline.intValue()));
        }
        if ((hanging = ((PPrBase.Ind)this.getObject()).getHanging()) != null) {
            prop = prop + Indent.composeCss(FO_NAME_TEXT_INDENT, "-" + UnitsOfMeasurement.twipToBest(hanging.intValue()));
        }
        if (left == null && firstline == null && hanging == null) {
            log.debug((Object)("What to do with " + XmlUtils.marshaltoString(this.getObject(), true, true)));
            prop = "";
        }
        return prop;
    }

    public void setXslFO(Element foElement) {
        BigInteger firstLine;
        boolean updated = false;
        BigInteger left = ((PPrBase.Ind)this.getObject()).getLeft();
        if (left != null) {
            foElement.setAttribute(FO_NAME, UnitsOfMeasurement.twipToBest(left.intValue()));
            updated = true;
        }
        if ((firstLine = ((PPrBase.Ind)this.getObject()).getFirstLine()) != null) {
            foElement.setAttribute(FO_NAME_TEXT_INDENT, UnitsOfMeasurement.twipToBest(firstLine.intValue()));
            updated = true;
        }
        if (!updated) {
            log.warn((Object)"Only left/first-line indentation is handled at present");
        }
    }

    public void set(PPr pPr) {
        pPr.setInd((PPrBase.Ind)this.getObject());
    }
}

