/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.PartName;

public final class URIHelper {
    private static Logger log = Logger.getLogger(URIHelper.class);
    private static URI packageRootUri;
    public static final String RELATIONSHIP_PART_EXTENSION_NAME;
    public static final String RELATIONSHIP_PART_SEGMENT_NAME;
    public static final String PACKAGE_PROPERTIES_SEGMENT_NAME;
    public static final String PACKAGE_CORE_PROPERTIES_NAME;
    public static final char FORWARD_SLASH_CHAR;
    public static final String FORWARD_SLASH_STRING;
    public static final URI PACKAGE_RELATIONSHIPS_ROOT_URI;
    public static final PartName PACKAGE_RELATIONSHIPS_ROOT_PART_NAME;
    public static final URI CORE_PROPERTIES_URI;
    public static final PartName CORE_PROPERTIES_PART_NAME;
    public static final URI PACKAGE_ROOT_URI;
    public static final PartName PACKAGE_ROOT_PART_NAME;

    public static URI getPackageRootUri() {
        return packageRootUri;
    }

    private static boolean isRelationshipPartURI(URI partUri) {
        if (partUri == null) {
            throw new NullPointerException("partUri");
        }
        return partUri.getPath().matches(".*" + RELATIONSHIP_PART_SEGMENT_NAME + ".*" + RELATIONSHIP_PART_EXTENSION_NAME + "$");
    }

    public static String getFilename(URI uri) {
        if (uri != null) {
            int len;
            String path = uri.getPath();
            int num2 = len = path.length();
            while (--num2 >= 0) {
                char ch1 = path.charAt(num2);
                if (ch1 != FORWARD_SLASH_CHAR) continue;
                return path.substring(num2 + 1, len);
            }
        }
        return "";
    }

    public static String getFilenameWithoutExtension(URI uri) {
        String filename = URIHelper.getFilename(uri);
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex == -1) {
            return filename;
        }
        return filename.substring(0, dotIndex);
    }

    public static URI getPath(URI uri) {
        if (uri != null) {
            int len;
            String path = uri.getPath();
            int num2 = len = path.length();
            while (--num2 >= 0) {
                char ch1 = path.charAt(num2);
                if (ch1 != FORWARD_SLASH_CHAR) continue;
                try {
                    return new URI(path.substring(0, num2));
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static URI combine(URI prefix, URI suffix) {
        URI retUri = null;
        try {
            retUri = new URI(URIHelper.combine(prefix.getPath(), suffix.getPath()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Prefix and suffix can't be combined !");
        }
        return retUri;
    }

    public static String combine(String prefix, String suffix) {
        if (!prefix.endsWith("" + FORWARD_SLASH_CHAR) && !suffix.startsWith("" + FORWARD_SLASH_CHAR)) {
            return prefix + FORWARD_SLASH_CHAR + suffix;
        }
        if (!prefix.endsWith("" + FORWARD_SLASH_CHAR) && suffix.startsWith("" + FORWARD_SLASH_CHAR) || prefix.endsWith("" + FORWARD_SLASH_CHAR) && !suffix.startsWith("" + FORWARD_SLASH_CHAR)) {
            return prefix + suffix;
        }
        return "";
    }

    public static URI relativizeURI(URI sourceURI, URI targetURI) {
        int i;
        StringBuilder retVal = new StringBuilder();
        String[] segmentsSource = sourceURI.getPath().split("/", -1);
        String[] segmentsTarget = targetURI.getPath().split("/", -1);
        if (segmentsSource.length == 0) {
            throw new IllegalArgumentException("Can't relativize an empty source URI !");
        }
        if (segmentsTarget.length == 0) {
            throw new IllegalArgumentException("Can't relativize an empty target URI !");
        }
        if (sourceURI.toString().equals("/")) {
            return targetURI;
        }
        int segmentsTheSame = 0;
        for (i = 0; i < segmentsSource.length && i < segmentsTarget.length && segmentsSource[i].equals(segmentsTarget[i]); ++i) {
            ++segmentsTheSame;
        }
        if ((segmentsTheSame == 0 || segmentsTheSame == 1) && segmentsSource[0].equals("") && segmentsTarget[0].equals("")) {
            for (i = 0; i < segmentsSource.length - 2; ++i) {
                retVal.append("../");
            }
            for (i = 0; i < segmentsTarget.length; ++i) {
                if (segmentsTarget[i].equals("")) continue;
                retVal.append(segmentsTarget[i]);
                if (i == segmentsTarget.length - 1) continue;
                retVal.append("/");
            }
            try {
                return new URI(retVal.toString());
            }
            catch (Exception e) {
                System.err.println(e);
                return null;
            }
        }
        if (segmentsTheSame == segmentsSource.length && segmentsTheSame == segmentsTarget.length) {
            retVal.append("");
        } else {
            int j;
            if (segmentsTheSame == 1) {
                retVal.append("/");
            } else {
                for (j = segmentsTheSame; j < segmentsSource.length - 1; ++j) {
                    retVal.append("../");
                }
            }
            for (j = segmentsTheSame; j < segmentsTarget.length; ++j) {
                if (retVal.length() > 0 && retVal.charAt(retVal.length() - 1) != '/') {
                    retVal.append("/");
                }
                retVal.append(segmentsTarget[j]);
            }
        }
        try {
            return new URI(retVal.toString());
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    public static URI resolvePartUri(URI sourcePartUri, URI targetUri) {
        if (sourcePartUri == null || sourcePartUri.isAbsolute()) {
            throw new IllegalArgumentException("sourcePartUri");
        }
        if (targetUri == null) {
            log.error((Object)"targetUri was null");
            throw new IllegalArgumentException("targetUri");
        }
        if (targetUri.isAbsolute()) {
            log.error((Object)("targetUri " + targetUri.toString() + " is absolute!"));
            throw new IllegalArgumentException("targetUri");
        }
        URI uri = sourcePartUri.resolve(targetUri);
        return uri;
    }

    public static URI getURIFromPath(String path) {
        URI retUri = null;
        try {
            retUri = new URI(path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("path");
        }
        return retUri;
    }

    public static URI getSourcePartUriFromRelationshipPartUri(URI relationshipPartUri) {
        if (relationshipPartUri == null) {
            throw new IllegalArgumentException("The relationshipPart Uri was null !");
        }
        if (!URIHelper.isRelationshipPartURI(relationshipPartUri)) {
            throw new IllegalArgumentException("L'URI ne doit pas \ufffdtre celle d'une partie de type relation.");
        }
        if (relationshipPartUri.compareTo(PACKAGE_RELATIONSHIPS_ROOT_URI) == 0) {
            return PACKAGE_ROOT_URI;
        }
        String filename = relationshipPartUri.getPath();
        String filenameWithoutExtension = URIHelper.getFilenameWithoutExtension(relationshipPartUri);
        filename = filename.substring(0, filename.length() - filenameWithoutExtension.length() - RELATIONSHIP_PART_EXTENSION_NAME.length());
        filename = filename.substring(0, filename.length() - RELATIONSHIP_PART_SEGMENT_NAME.length() - 1);
        filename = URIHelper.combine(filename, filenameWithoutExtension);
        return URIHelper.getURIFromPath(filename);
    }

    public static PartName createPartName(URI partUri) throws InvalidFormatException {
        if (partUri == null) {
            throw new IllegalArgumentException("partName");
        }
        return new PartName(partUri, true);
    }

    public static PartName createPartName(String partName) throws InvalidFormatException {
        URI partNameURI;
        try {
            partNameURI = new URI(partName);
        }
        catch (URISyntaxException e) {
            throw new InvalidFormatException(e.getMessage());
        }
        return URIHelper.createPartName(partNameURI);
    }

    public static boolean isValidPartName(URI partUri) {
        if (partUri == null) {
            throw new IllegalArgumentException("partUri");
        }
        try {
            URIHelper.createPartName(partUri);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String decodeURI(URI uri) {
        StringBuffer retVal = new StringBuffer();
        String uriStr = uri.toASCIIString();
        for (int i = 0; i < uriStr.length(); ++i) {
            char c = uriStr.charAt(i);
            if (c == '%') {
                if (uriStr.length() - i < 2) {
                    throw new IllegalArgumentException("The uri " + uriStr + " contain invalid encoded character !");
                }
                char decodedChar = (char)Integer.parseInt(uriStr.substring(i + 1, i + 3), 16);
                retVal.append(decodedChar);
                i += 2;
                continue;
            }
            retVal.append(c);
        }
        return retVal.toString();
    }

    static {
        RELATIONSHIP_PART_SEGMENT_NAME = "_rels";
        RELATIONSHIP_PART_EXTENSION_NAME = ".rels";
        FORWARD_SLASH_CHAR = (char)47;
        FORWARD_SLASH_STRING = "/";
        PACKAGE_PROPERTIES_SEGMENT_NAME = "docProps";
        PACKAGE_CORE_PROPERTIES_NAME = "core.xml";
        URI uriPACKAGE_ROOT_URI = null;
        URI uriPACKAGE_RELATIONSHIPS_ROOT_URI = null;
        URI uriPACKAGE_PROPERTIES_URI = null;
        try {
            uriPACKAGE_ROOT_URI = new URI("/");
            uriPACKAGE_RELATIONSHIPS_ROOT_URI = new URI(FORWARD_SLASH_CHAR + RELATIONSHIP_PART_SEGMENT_NAME + FORWARD_SLASH_CHAR + RELATIONSHIP_PART_EXTENSION_NAME);
            packageRootUri = new URI("/");
            uriPACKAGE_PROPERTIES_URI = new URI(FORWARD_SLASH_CHAR + PACKAGE_PROPERTIES_SEGMENT_NAME + FORWARD_SLASH_CHAR + PACKAGE_CORE_PROPERTIES_NAME);
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        PACKAGE_ROOT_URI = uriPACKAGE_ROOT_URI;
        PACKAGE_RELATIONSHIPS_ROOT_URI = uriPACKAGE_RELATIONSHIPS_ROOT_URI;
        CORE_PROPERTIES_URI = uriPACKAGE_PROPERTIES_URI;
        PartName tmpPACKAGE_ROOT_PART_NAME = null;
        PartName tmpPACKAGE_RELATIONSHIPS_ROOT_PART_NAME = null;
        PartName tmpCORE_PROPERTIES_URI = null;
        try {
            tmpPACKAGE_RELATIONSHIPS_ROOT_PART_NAME = URIHelper.createPartName(PACKAGE_RELATIONSHIPS_ROOT_URI);
            tmpCORE_PROPERTIES_URI = URIHelper.createPartName(CORE_PROPERTIES_URI);
            tmpPACKAGE_ROOT_PART_NAME = new PartName(PACKAGE_ROOT_URI, false);
        }
        catch (InvalidFormatException e) {
            // empty catch block
        }
        PACKAGE_RELATIONSHIPS_ROOT_PART_NAME = tmpPACKAGE_RELATIONSHIPS_ROOT_PART_NAME;
        CORE_PROPERTIES_PART_NAME = tmpCORE_PROPERTIES_URI;
        PACKAGE_ROOT_PART_NAME = tmpPACKAGE_ROOT_PART_NAME;
    }
}

