/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.io;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.bibliography.CTSources;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.CustomXmlDataStorage;
import org.docx4j.model.datastorage.CustomXmlDataStorageImpl;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePropertiesPart;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.openpackaging.parts.WordprocessingML.BibliographyPart;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.opendope.ComponentsPart;
import org.docx4j.openpackaging.parts.opendope.ConditionsPart;
import org.docx4j.openpackaging.parts.opendope.QuestionsPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.relationships.Relationship;
import org.opendope.components.Components;
import org.opendope.conditions.Conditions;
import org.opendope.questions.Questionnaire;
import org.opendope.xpaths.Xpaths;
import org.w3c.dom.Document;

public class Load {
    private static Logger log = Logger.getLogger(Load.class);
    protected boolean loadExternalTargets = false;
    protected static CustomXmlDataStorage customXmlDataStorageClass = null;

    public void loadExternalTargets(boolean loadExternalTargets) {
        this.loadExternalTargets = loadExternalTargets;
    }

    public static void setCustomXmlDataStorageClass(CustomXmlDataStorage customXmlDataStorageClassVal) {
        customXmlDataStorageClass = customXmlDataStorageClassVal;
    }

    public static CustomXmlDataStorage getCustomXmlDataStorageClass() {
        try {
            if (customXmlDataStorageClass == null) {
                customXmlDataStorageClass = new CustomXmlDataStorageImpl();
            }
            return customXmlDataStorageClass;
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Part getRawPart(InputStream is, ContentTypeManager ctm, String resolvedPartUri, Relationship rel) throws Docx4JException {
        Part part;
        block19: {
            part = null;
            try {
                try {
                    part = ctm.getPart("/" + resolvedPartUri, rel);
                    if (part instanceof ThemePart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcThemePart);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block19;
                    }
                    if (part instanceof DocPropsCorePart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcDocPropsCore);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block19;
                    }
                    if (part instanceof DocPropsCustomPart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcDocPropsCustom);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block19;
                    }
                    if (part instanceof DocPropsExtendedPart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcDocPropsExtended);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block19;
                    }
                    if (part instanceof CustomXmlDataStoragePropertiesPart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcCustomXmlProperties);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block19;
                    }
                    if (part instanceof JaxbXmlPart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jc);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block19;
                    }
                    if (part instanceof BinaryPart) {
                        log.debug((Object)("Detected BinaryPart " + part.getClass().getName()));
                        ((BinaryPart)part).setBinaryData(is);
                        break block19;
                    }
                    if (part instanceof CustomXmlDataStoragePart) {
                        try {
                            Unmarshaller u = Context.jc.createUnmarshaller();
                            Object o = u.unmarshal(is);
                            log.debug((Object)o.getClass().getName());
                            PartName name = part.getPartName();
                            if (o instanceof Conditions) {
                                part = new ConditionsPart(name);
                                ((ConditionsPart)part).setJaxbElement((Conditions)o);
                                break block19;
                            }
                            if (o instanceof Xpaths) {
                                part = new XPathsPart(name);
                                ((XPathsPart)part).setJaxbElement((Xpaths)o);
                                break block19;
                            }
                            if (o instanceof Questionnaire) {
                                part = new QuestionsPart(name);
                                ((QuestionsPart)part).setJaxbElement((Questionnaire)o);
                                break block19;
                            }
                            if (o instanceof Components) {
                                part = new ComponentsPart(name);
                                ((ComponentsPart)part).setJaxbElement((Components)o);
                                break block19;
                            }
                            if (o instanceof JAXBElement && XmlUtils.unwrap(o) instanceof CTSources) {
                                part = new BibliographyPart(name);
                                ((BibliographyPart)part).setJaxbElement((JAXBElement)o);
                                break block19;
                            }
                            log.warn((Object)("No known part after all for CustomXmlPart " + o.getClass().getName()));
                            CustomXmlDataStorage data = Load.getCustomXmlDataStorageClass().factory();
                            is.reset();
                            data.setDocument(is);
                            ((CustomXmlDataStoragePart)part).setData(data);
                        }
                        catch (UnmarshalException ue) {
                            CustomXmlDataStorage data = Load.getCustomXmlDataStorageClass().factory();
                            is.reset();
                            data.setDocument(is);
                            ((CustomXmlDataStoragePart)part).setData(data);
                        }
                        break block19;
                    }
                    log.error((Object)("No suitable part found for: " + resolvedPartUri));
                    return null;
                }
                catch (PartUnrecognisedException e) {
                    part = new BinaryPart(new PartName("/" + resolvedPartUri));
                    ((BinaryPart)part).setBinaryData(is);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Docx4JException("Failed to getPart", ex);
            }
        }
        return part;
    }

    public static void registerCustomXmlDataStorageParts(OpcPackage pkg) {
        HashMap<PartName, Part> parts = pkg.getParts().getParts();
        Collection<Part> col = parts.values();
        for (Part entry : col) {
            String itemId;
            block6: {
                if (!(entry instanceof CustomXmlDataStoragePart)) continue;
                log.debug((Object)("Found a CustomXmlDataStoragePart, named " + entry.getPartName().getName()));
                itemId = null;
                if (entry.getRelationshipsPart() == null) continue;
                log.debug((Object)".. it has a rels part");
                Relationship r = entry.getRelationshipsPart().getRelationshipByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXmlProps");
                if (r == null) {
                    log.debug((Object)".. but that doesn't point to a  customXmlProps part");
                    continue;
                }
                CustomXmlDataStoragePropertiesPart customXmlProps = (CustomXmlDataStoragePropertiesPart)entry.getRelationshipsPart().getPart(r);
                if (customXmlProps == null) {
                    log.error((Object)".. but the target seems to be missing?");
                    try {
                        Document document = ((CustomXmlDataStoragePart)entry).getData().getDocument();
                        String localName = document.getDocumentElement().getLocalName();
                        log.debug((Object)localName);
                        if (!document.getDocumentElement().isDefaultNamespace("http://schemas.microsoft.com/?office/?2006/?coverPageProps") && !localName.equals("CoverPageProperties")) continue;
                        itemId = "{55AF091B-3C7A-41E3-B477-F2FDAA23CFDA}".toLowerCase();
                        break block6;
                    }
                    catch (Docx4JException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                itemId = customXmlProps.getItemId().toLowerCase();
            }
            log.info((Object)("Identified/registered ds:itemId " + itemId));
            if (pkg.getCustomXmlDataStorageParts().get(itemId.toLowerCase()) != null) {
                log.warn((Object)("Duplicate CustomXML itemId " + itemId + "; check your source docx!"));
            }
            pkg.getCustomXmlDataStorageParts().put(itemId, (CustomXmlDataStoragePart)entry);
        }
    }
}

