/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.AltChunkType;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;

public final class AlternativeFormatInputPart
extends BinaryPart {
    AltChunkType type;

    public AlternativeFormatInputPart(PartName partName) throws InvalidFormatException {
        super(partName);
        if (partName.getExtension().toLowerCase().equals("xhtml")) {
            this.type = AltChunkType.Xhtml;
        } else if (partName.getExtension().toLowerCase().equals("mht")) {
            this.type = AltChunkType.Mht;
        } else if (partName.getExtension().toLowerCase().equals("xml")) {
            this.type = AltChunkType.Xml;
        } else if (partName.getExtension().toLowerCase().equals("txt")) {
            this.type = AltChunkType.TextPlain;
        } else if (partName.getExtension().toLowerCase().equals("docx")) {
            this.type = AltChunkType.WordprocessingML;
        } else if (partName.getExtension().toLowerCase().equals("docx")) {
            this.type = AltChunkType.OfficeWordMacroEnabled;
        } else if (partName.getExtension().toLowerCase().equals("dotx")) {
            this.type = AltChunkType.OfficeWordTemplate;
        } else if (partName.getExtension().toLowerCase().equals("dotm")) {
            this.type = AltChunkType.OfficeWordMacroEnabledTemplate;
        } else if (partName.getExtension().toLowerCase().equals("rtf")) {
            this.type = AltChunkType.Rtf;
        } else if (partName.getExtension().toLowerCase().equals("html")) {
            this.type = AltChunkType.Html;
        }
        this.setContentType();
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/aFChunk");
    }

    public AltChunkType getAltChunkType() {
        return this.type;
    }

    public AlternativeFormatInputPart(AltChunkType type) throws InvalidFormatException {
        super(new PartName("/chunk"));
        this.type = type;
        if (type.equals((Object)AltChunkType.Xhtml)) {
            this.partName = new PartName("/chunk.xhtml");
        } else if (type.equals((Object)AltChunkType.Mht)) {
            this.partName = new PartName("/chunk.mht");
        } else if (type.equals((Object)AltChunkType.Xml)) {
            this.partName = new PartName("/chunk.xml");
        } else if (type.equals((Object)AltChunkType.TextPlain)) {
            this.partName = new PartName("/chunk.txt");
        } else if (type.equals((Object)AltChunkType.WordprocessingML)) {
            this.partName = new PartName("/chunk.docx");
        } else if (type.equals((Object)AltChunkType.OfficeWordMacroEnabled)) {
            this.partName = new PartName("/chunk.docm");
        } else if (type.equals((Object)AltChunkType.OfficeWordTemplate)) {
            this.partName = new PartName("/chunk.dotx");
        } else if (type.equals((Object)AltChunkType.OfficeWordMacroEnabledTemplate)) {
            this.partName = new PartName("/chunk.dotm");
        } else if (type.equals((Object)AltChunkType.Rtf)) {
            this.partName = new PartName("/chunk.rtf");
        } else if (type.equals((Object)AltChunkType.Html)) {
            this.partName = new PartName("/chunk.html");
        }
        this.setContentType();
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/aFChunk");
    }

    private void setContentType() {
        if (this.type.equals((Object)AltChunkType.Xhtml)) {
            this.setContentType(new ContentType("application/xhtml+xml"));
        } else if (this.type.equals((Object)AltChunkType.Mht)) {
            this.setContentType(new ContentType("multipart/related"));
        } else if (this.type.equals((Object)AltChunkType.Xml)) {
            this.setContentType(new ContentType("application/xml"));
        } else if (this.type.equals((Object)AltChunkType.TextPlain)) {
            this.setContentType(new ContentType("text/plain"));
        } else if (this.type.equals((Object)AltChunkType.WordprocessingML)) {
            this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml"));
        } else if (this.type.equals((Object)AltChunkType.OfficeWordMacroEnabled)) {
            this.setContentType(new ContentType("application/vnd.ms-word.document.macroEnabled.main+xml"));
        } else if (this.type.equals((Object)AltChunkType.OfficeWordTemplate)) {
            this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml"));
        } else if (this.type.equals((Object)AltChunkType.OfficeWordMacroEnabledTemplate)) {
            this.setContentType(new ContentType("application/vnd.ms-word.template.macroEnabledTemplate.main+xml"));
        } else if (this.type.equals((Object)AltChunkType.Rtf)) {
            this.setContentType(new ContentType("text/rtf"));
        } else if (this.type.equals((Object)AltChunkType.Html)) {
            this.setContentType(new ContentType("text/html"));
        }
    }

    public void registerInContentTypeManager() {
        ContentTypeManager ctm = this.getPackage().getContentTypeManager();
        if (this.type.equals((Object)AltChunkType.Xhtml)) {
            ctm.addDefaultContentType("xhtml", "application/xhtml+xml");
        } else if (this.type.equals((Object)AltChunkType.Mht)) {
            ctm.addDefaultContentType("mht", "multipart/related");
        } else if (this.type.equals((Object)AltChunkType.Xml)) {
            ctm.addDefaultContentType("xml", "application/xml");
        } else if (this.type.equals((Object)AltChunkType.TextPlain)) {
            ctm.addDefaultContentType("txt", "text/plain");
        } else if (this.type.equals((Object)AltChunkType.WordprocessingML)) {
            ctm.addDefaultContentType("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml");
        } else if (this.type.equals((Object)AltChunkType.OfficeWordMacroEnabled)) {
            ctm.addDefaultContentType("docm", "application/vnd.ms-word.document.macroEnabled.main+xml");
        } else if (this.type.equals((Object)AltChunkType.OfficeWordTemplate)) {
            ctm.addDefaultContentType("dotx", "application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml");
        } else if (this.type.equals((Object)AltChunkType.OfficeWordMacroEnabledTemplate)) {
            ctm.addDefaultContentType("dotm", "application/vnd.ms-word.template.macroEnabledTemplate.main+xml");
        } else if (this.type.equals((Object)AltChunkType.Rtf)) {
            ctm.addDefaultContentType("rtf", "text/rtf");
        } else if (this.type.equals((Object)AltChunkType.Html)) {
            ctm.addDefaultContentType("html", "text/html");
        }
    }
}

