/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.poi.poifs.dev.POIFSLister;
import org.apache.poi.poifs.dev.POIFSViewEngine;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;

public class OleObjectBinaryPart
extends BinaryPart {
    private static Logger log = Logger.getLogger(OleObjectBinaryPart.class);
    POIFSFileSystem fs;

    public OleObjectBinaryPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public OleObjectBinaryPart() throws InvalidFormatException {
        super(new PartName("/word/embeddings/oleObject1.bin"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.oleObject"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject");
    }

    public POIFSFileSystem getFs() {
        return this.fs;
    }

    public void initPOIFSFileSystem() throws IOException {
        this.bb.clear();
        byte[] bytes = new byte[this.bb.capacity()];
        this.bb.get(bytes, 0, bytes.length);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        this.fs = new POIFSFileSystem((InputStream)bais);
    }

    public void writePOIFSFileSystem() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.fs.writeFilesystem((OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        this.bb = ByteBuffer.wrap(bytes);
    }

    public void viewFile(boolean verbose) throws IOException {
        String indent = "";
        boolean withSizes = true;
        POIFSLister.displayDirectory((DirectoryNode)this.fs.getRoot(), (String)indent, (boolean)withSizes);
        if (verbose) {
            List strings = POIFSViewEngine.inspectViewable((Object)this.fs, (boolean)true, (int)0, (String)"  ");
            Iterator iter = strings.iterator();
            while (iter.hasNext()) {
                System.out.print(iter.next());
            }
        }
    }
}

